jQuery(() => {
  const selectorFilter = jQuery('#filter');
  const selectorCards = jQuery('.icons-card');
  const cards = [];
  selectorCards.each((i) => {
    const item = jQuery(selectorCards[i]);
    const name = item.find('.icons-card-name').text().toLowerCase();
    cards.push({ name, item });
  });
  selectorFilter.keyup(() => {
    const value = selectorFilter.val().toLowerCase();
    cards.forEach(({ name, item }) => {
      if (name.indexOf(value) < 0) {
        item.hide();
      } else {
        item.show();
      }
    });
  });
});
