--
-- PostgreSQL database dump
--

\restrict u7Fu9aASc9b6XuPhhg7MwGCJPiPMYsvd3Bo3BWvMT5TsBFn7H6SDFVkhmL6l1Ua

-- Dumped from database version 15.15
-- Dumped by pg_dump version 15.15

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: tiger; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tiger;


ALTER SCHEMA tiger OWNER TO postgres;

--
-- Name: tiger_data; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tiger_data;


ALTER SCHEMA tiger_data OWNER TO postgres;

--
-- Name: topology; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA topology;


ALTER SCHEMA topology OWNER TO postgres;

--
-- Name: SCHEMA topology; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA topology IS 'PostGIS Topology schema';


--
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- Name: postgis_tiger_geocoder; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_tiger_geocoder WITH SCHEMA tiger;


--
-- Name: EXTENSION postgis_tiger_geocoder; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_tiger_geocoder IS 'PostGIS tiger geocoder and reverse geocoder';


--
-- Name: postgis_topology; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_topology WITH SCHEMA topology;


--
-- Name: EXTENSION postgis_topology; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_topology IS 'PostGIS topology spatial types and functions';


--
-- Name: f_before_delete_logs(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.f_before_delete_logs() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      BEGIN
        RAISE EXCEPTION 'Records cannot be deleted from this table.';
      END;
      $$;


ALTER FUNCTION public.f_before_delete_logs() OWNER TO postgres;

--
-- Name: f_before_update_logs(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.f_before_update_logs() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
      BEGIN
        IF TG_OP = 'UPDATE' AND (
          OLD.id IS DISTINCT FROM NEW.id OR
          OLD.message IS DISTINCT FROM NEW.message OR
          OLD.create_date IS DISTINCT FROM NEW.create_date OR
          OLD.user_id IS DISTINCT FROM NEW.user_id OR
          OLD.ip IS DISTINCT FROM NEW.ip OR
          OLD.subsystem_id IS DISTINCT FROM NEW.subsystem_id OR
          OLD.action IS DISTINCT FROM NEW.action OR
          OLD.data_id IS DISTINCT FROM NEW.data_id OR
          OLD.before IS DISTINCT FROM NEW.before OR
          OLD.after IS DISTINCT FROM NEW.after OR
          OLD.real_user_id IS DISTINCT FROM NEW.real_user_id OR
          (OLD.sign IS NOT NULL AND OLD.sign IS DISTINCT FROM NEW.sign) OR
          (OLD.sign_prev IS NOT NULL AND OLD.sign_prev IS DISTINCT FROM NEW.sign_prev) OR
          (OLD.sign_next IS NOT NULL AND OLD.sign_next IS DISTINCT FROM NEW.sign_next)
        ) THEN
          RAISE EXCEPTION 'Updating is only allowed for certain columns.';
        END IF;
        RETURN NEW;
      END;
      $$;


ALTER FUNCTION public.f_before_update_logs() OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: adapter; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.adapter (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(32) NOT NULL,
    permission_id character varying(32),
    enable boolean DEFAULT true NOT NULL,
    config text NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.adapter OWNER TO postgres;

--
-- Name: callback_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.callback_event (
    id integer NOT NULL,
    uid character varying(255),
    object_id character varying(255),
    type character varying(32) NOT NULL,
    title character varying(255),
    message text,
    images character varying(255)[] DEFAULT (ARRAY[]::character varying[])::character varying(255)[] NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.callback_event OWNER TO postgres;

--
-- Name: callback_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.callback_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.callback_event_id_seq OWNER TO postgres;

--
-- Name: callback_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.callback_event_id_seq OWNED BY public.callback_event.id;


--
-- Name: citizens_appeals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.citizens_appeals (
    id integer NOT NULL,
    fio character varying(255),
    phone character varying(32),
    email character varying(255),
    message text NOT NULL,
    ip character varying(64) NOT NULL,
    user_agent character varying(255) NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.citizens_appeals OWNER TO postgres;

--
-- Name: citizens_appeals_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.citizens_appeals_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.citizens_appeals_id_seq OWNER TO postgres;

--
-- Name: citizens_appeals_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.citizens_appeals_id_seq OWNED BY public.citizens_appeals.id;


--
-- Name: comment; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.comment (
    id integer NOT NULL,
    message text NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    object_type character varying(64) NOT NULL,
    object_id character varying(64) NOT NULL,
    create_user_id integer,
    update_user_id integer,
    title character varying(128) DEFAULT ''::character varying NOT NULL,
    link character varying(256)
);


ALTER TABLE public.comment OWNER TO postgres;

--
-- Name: comment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.comment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.comment_id_seq OWNER TO postgres;

--
-- Name: comment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.comment_id_seq OWNED BY public.comment.id;


--
-- Name: ct_override; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ct_override (
    id integer NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    data_type character varying(32) NOT NULL,
    subsystem_id character varying(32) NOT NULL,
    data_id character varying(255) NOT NULL,
    set character varying(255) NOT NULL,
    value_type character varying(32) NOT NULL,
    value text NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer
);


ALTER TABLE public.ct_override OWNER TO postgres;

--
-- Name: ct_override_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ct_override_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ct_override_id_seq OWNER TO postgres;

--
-- Name: ct_override_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ct_override_id_seq OWNED BY public.ct_override.id;


--
-- Name: dashboard; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dashboard (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    read_perm_id character varying(32),
    edit_perm_id character varying(32),
    is_private boolean DEFAULT true NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    config text NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.dashboard OWNER TO postgres;

--
-- Name: data_source; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.data_source (
    id character varying(32) NOT NULL,
    subsystem_id character varying(32) NOT NULL,
    protocol character varying(32) NOT NULL,
    description text NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    params text DEFAULT '{}'::text NOT NULL,
    permission_id character varying(32),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    credentials text,
    auth_type character varying(32) DEFAULT 'none'::character varying NOT NULL,
    credentials_next_update timestamp without time zone,
    enable boolean DEFAULT true NOT NULL,
    user_params boolean DEFAULT false NOT NULL
);


ALTER TABLE public.data_source OWNER TO postgres;

--
-- Name: TABLE data_source; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.data_source IS 'Источники получения данных';


--
-- Name: COLUMN data_source.config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.data_source.config IS 'Кодированный JSON с параметрвми подключения. Хост, порт, логин, пароль, и прочее. Формат зависит от протокола.';


--
-- Name: COLUMN data_source.params; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.data_source.params IS 'Параметры, которые можно использовать как переменные окружения при построении запросов. Например, логин и пароль';


--
-- Name: data_source_query; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.data_source_query (
    id character varying(32) NOT NULL,
    data_source_id character varying(32) NOT NULL,
    validator_id integer,
    description text DEFAULT ''::text NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    log_enable boolean DEFAULT false NOT NULL,
    log_weight integer DEFAULT 1 NOT NULL,
    log_limit_size integer DEFAULT 52428800 NOT NULL,
    log_limit_max integer DEFAULT 1000 NOT NULL,
    log_stat_count1h integer DEFAULT 0 NOT NULL,
    log_stat_count2h integer DEFAULT 0 NOT NULL,
    log_stat_count4h integer DEFAULT 0 NOT NULL,
    log_stat_size integer DEFAULT 0 NOT NULL,
    log_stat_count integer DEFAULT 0 NOT NULL,
    log_stat_errors1h integer DEFAULT 0 NOT NULL,
    permission_id character varying(32),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    enable boolean DEFAULT true NOT NULL
);


ALTER TABLE public.data_source_query OWNER TO postgres;

--
-- Name: COLUMN data_source_query.config; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.data_source_query.config IS 'Кодированный JSON параметры запроса. Зависят от протокола.';


--
-- Name: data_source_user_params; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.data_source_user_params (
    id integer NOT NULL,
    user_id integer NOT NULL,
    data_source_id character varying(32) NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    params text NOT NULL,
    credentials text,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    update_user_id integer NOT NULL,
    credentials_next_update timestamp without time zone
);


ALTER TABLE public.data_source_user_params OWNER TO postgres;

--
-- Name: data_source_user_params_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.data_source_user_params_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.data_source_user_params_id_seq OWNER TO postgres;

--
-- Name: data_source_user_params_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.data_source_user_params_id_seq OWNED BY public.data_source_user_params.id;


--
-- Name: dc_config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_config (
    id character varying(32) NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    data_type character varying(32) NOT NULL,
    "interval" integer DEFAULT 3600 NOT NULL,
    name character varying(32) NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    create_user_id integer,
    update_user_id integer,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    actual_data boolean DEFAULT false NOT NULL,
    scanning_depth integer DEFAULT 86400 NOT NULL,
    delete boolean DEFAULT false NOT NULL
);


ALTER TABLE public.dc_config OWNER TO postgres;

--
-- Name: dc_config_subsystem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_config_subsystem (
    dc_config_id character varying(32) NOT NULL,
    subsystem_id character varying(32) NOT NULL
);


ALTER TABLE public.dc_config_subsystem OWNER TO postgres;

--
-- Name: dc_event; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_event (
    id integer NOT NULL,
    dc_config_id character varying(32) NOT NULL,
    date timestamp with time zone NOT NULL,
    data_id character varying(255) DEFAULT ''::text NOT NULL,
    data text DEFAULT '{}'::text NOT NULL,
    status character varying(32) NOT NULL,
    log text DEFAULT '{}'::text NOT NULL,
    dc_config text DEFAULT '{}'::text NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    description character varying(1023)
);


ALTER TABLE public.dc_event OWNER TO postgres;

--
-- Name: dc_event_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.dc_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dc_event_id_seq OWNER TO postgres;

--
-- Name: dc_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.dc_event_id_seq OWNED BY public.dc_event.id;


--
-- Name: dc_flag; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_flag (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    description text NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    tags character varying(32)[] DEFAULT (ARRAY[]::character varying[])::character varying(32)[] NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer
);


ALTER TABLE public.dc_flag OWNER TO postgres;

--
-- Name: dc_flag_device; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_flag_device (
    id integer NOT NULL,
    dc_flag_id character varying(32) NOT NULL,
    data_type character varying(32) NOT NULL,
    subsystem_id character varying(32) NOT NULL,
    device_id character varying(32) NOT NULL,
    status boolean DEFAULT true NOT NULL,
    lvl integer DEFAULT 0 NOT NULL,
    reason character varying(32) NOT NULL,
    expiries timestamp with time zone,
    date timestamp with time zone DEFAULT now() NOT NULL,
    user_id integer,
    dc_config_id character varying(32),
    dc_task_id integer
);


ALTER TABLE public.dc_flag_device OWNER TO postgres;

--
-- Name: COLUMN dc_flag_device.date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dc_flag_device.date IS 'Create date';


--
-- Name: COLUMN dc_flag_device.user_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.dc_flag_device.user_id IS 'Create user ID';


--
-- Name: dc_flag_device_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

ALTER TABLE public.dc_flag_device ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME public.dc_flag_device_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: dc_task; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.dc_task (
    id integer NOT NULL,
    dc_event_id integer NOT NULL,
    parent_id integer,
    parent_status character varying(32),
    type character varying(32) DEFAULT ''::character varying NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    status character varying(32) NOT NULL,
    next_repeat_date timestamp with time zone NOT NULL,
    lock_id character varying(32),
    lock_expires timestamp with time zone,
    repetitions_left integer NOT NULL,
    repetition_interval integer NOT NULL,
    error text,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.dc_task OWNER TO postgres;

--
-- Name: dc_task_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.dc_task_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.dc_task_id_seq OWNER TO postgres;

--
-- Name: dc_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.dc_task_id_seq OWNED BY public.dc_task.id;


--
-- Name: file; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.file (
    id integer NOT NULL,
    parent_id integer,
    is_dir boolean DEFAULT false NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text,
    ext character varying(16) DEFAULT ''::character varying NOT NULL,
    icon_id character varying(32),
    hash character varying(32),
    size bigint DEFAULT 0 NOT NULL,
    quota bigint DEFAULT 0 NOT NULL,
    file_count bigint DEFAULT 1 NOT NULL,
    perm_c character varying(32),
    perm_r character varying(32),
    perm_u character varying(32),
    perm_d character varying(32),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer,
    update_user_id integer
);


ALTER TABLE public.file OWNER TO postgres;

--
-- Name: COLUMN file.ext; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.ext IS 'Расширение';


--
-- Name: COLUMN file.quota; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.quota IS 'Лимит размера папки';


--
-- Name: COLUMN file.file_count; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.file_count IS 'Количество файлов в каталоге';


--
-- Name: COLUMN file.perm_c; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.perm_c IS 'загрузка файлов';


--
-- Name: COLUMN file.perm_r; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.perm_r IS 'Чтение файлов';


--
-- Name: COLUMN file.perm_u; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.perm_u IS 'Изменение файлов';


--
-- Name: COLUMN file.perm_d; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.file.perm_d IS 'удаление файлов';


--
-- Name: file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.file_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.file_id_seq OWNER TO postgres;

--
-- Name: file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.file_id_seq OWNED BY public.file.id;


--
-- Name: file_view; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.file_view (
    id integer NOT NULL,
    file_id integer NOT NULL,
    user_id integer NOT NULL,
    state text DEFAULT '{}'::text NOT NULL
);


ALTER TABLE public.file_view OWNER TO postgres;

--
-- Name: file_view_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.file_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.file_view_id_seq OWNER TO postgres;

--
-- Name: file_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.file_view_id_seq OWNED BY public.file_view.id;


--
-- Name: form; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.form (
    id character varying(32) NOT NULL,
    title character varying(255) NOT NULL,
    description text,
    config text DEFAULT '{}'::text NOT NULL,
    perm_c character varying(32),
    perm_r character varying(32),
    perm_u character varying(32),
    perm_d character varying(32),
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.form OWNER TO postgres;

--
-- Name: geo_collection; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.geo_collection (
    id character varying(32) NOT NULL,
    name character varying(255),
    description text,
    perm_r character varying(32),
    perm_u character varying(32),
    has_key boolean DEFAULT false NOT NULL,
    has_perm boolean DEFAULT false NOT NULL,
    has_meta boolean DEFAULT false NOT NULL,
    has_tags boolean DEFAULT false NOT NULL
);


ALTER TABLE public.geo_collection OWNER TO postgres;

--
-- Name: geo_object; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.geo_object (
    id integer NOT NULL,
    collection_id character varying(32) NOT NULL,
    key character varying(32),
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    geometry public.geometry NOT NULL,
    geometry_type character varying(32) NOT NULL,
    geometry_bounds public.geometry NOT NULL,
    geometry_hash character varying(32) NOT NULL,
    permission_id character varying(32),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    data_type character varying(32)[] DEFAULT '{}'::character varying[] NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    meta json DEFAULT '{}'::json NOT NULL,
    tags character varying(32)[] DEFAULT (ARRAY[]::character varying[])::character varying(32)[] NOT NULL
);


ALTER TABLE public.geo_object OWNER TO postgres;

--
-- Name: geo_object_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.geo_object_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.geo_object_id_seq OWNER TO postgres;

--
-- Name: geo_object_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.geo_object_id_seq OWNED BY public.geo_object.id;


--
-- Name: geo_object_ver; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.geo_object_ver (
    id integer NOT NULL,
    geometry text NOT NULL,
    geometry_type character varying(32) NOT NULL,
    geometry_bounds text NOT NULL,
    geometry_hash character varying(32) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    geo_object_id integer NOT NULL
);


ALTER TABLE public.geo_object_ver OWNER TO postgres;

--
-- Name: geo_object_ver_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.geo_object_ver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.geo_object_ver_id_seq OWNER TO postgres;

--
-- Name: geo_object_ver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.geo_object_ver_id_seq OWNED BY public.geo_object_ver.id;


--
-- Name: link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.link (
    id character varying(32) NOT NULL,
    text_ru character varying(255) NOT NULL,
    text_en character varying(255) NOT NULL,
    uri character varying(255) NOT NULL,
    log_msg character varying(255),
    permission_id character varying(32)
);


ALTER TABLE public.link OWNER TO postgres;

--
-- Name: logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.logs (
    id integer NOT NULL,
    message character varying NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    user_id integer NOT NULL,
    ip character varying DEFAULT ''::character varying,
    subsystem_id character varying(32),
    action character varying(32) NOT NULL,
    data_id character varying(64),
    before text,
    after text,
    real_user_id integer,
    sign bytea,
    sign_prev bytea,
    sign_next bytea
);


ALTER TABLE public.logs OWNER TO postgres;

--
-- Name: logs_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.logs_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.logs_id_seq OWNER TO postgres;

--
-- Name: logs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.logs_id_seq OWNED BY public.logs.id;


--
-- Name: migrations_v2; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.migrations_v2 (
    id integer NOT NULL,
    "timestamp" bigint NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE public.migrations_v2 OWNER TO postgres;

--
-- Name: migrations_v2_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.migrations_v2_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.migrations_v2_id_seq OWNER TO postgres;

--
-- Name: migrations_v2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.migrations_v2_id_seq OWNED BY public.migrations_v2.id;


--
-- Name: module; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.module (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    type character varying(32) DEFAULT 'predefined'::character varying NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    is_private boolean DEFAULT false NOT NULL,
    read_perm_id character varying(32),
    edit_perm_id character varying(32),
    sort integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.module OWNER TO postgres;

--
-- Name: notification; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.notification (
    id integer NOT NULL,
    external_id character varying(255),
    type character varying(32) NOT NULL,
    tags character varying(255)[] DEFAULT (ARRAY[]::character varying[])::character varying(32)[] NOT NULL,
    lvl character varying(32) DEFAULT 'info'::character varying NOT NULL,
    title character varying(255) NOT NULL,
    message text NOT NULL,
    link character varying(255),
    data text,
    created timestamp with time zone DEFAULT now() NOT NULL,
    expiry timestamp with time zone,
    images character varying(255)[] DEFAULT (ARRAY[]::character varying[])::character varying(255)[] NOT NULL,
    button_config text
);


ALTER TABLE public.notification OWNER TO postgres;

--
-- Name: notification_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.notification_id_seq OWNER TO postgres;

--
-- Name: notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.notification_id_seq OWNED BY public.notification.id;


--
-- Name: notification_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.notification_user (
    user_id integer NOT NULL,
    notification_id integer NOT NULL,
    state character varying(32)
);


ALTER TABLE public.notification_user OWNER TO postgres;

--
-- Name: object; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.object (
    id integer NOT NULL,
    type character varying(32) NOT NULL,
    entity_id character varying(255),
    tags character varying(32)[] DEFAULT '{}'::character varying(32)[] NOT NULL,
    name character varying(255),
    object jsonb DEFAULT '{}'::jsonb NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.object OWNER TO postgres;

--
-- Name: object_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.object_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.object_id_seq OWNER TO postgres;

--
-- Name: object_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.object_id_seq OWNED BY public.object.id;


--
-- Name: permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permission (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    subsystem_id character varying(32) DEFAULT 'api'::character varying NOT NULL
);


ALTER TABLE public.permission OWNER TO postgres;

--
-- Name: permitted_route; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permitted_route (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    data text NOT NULL,
    data_hash character varying(32) NOT NULL,
    created timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    kml_hash character varying(32) NOT NULL,
    kml_name character varying(255) NOT NULL,
    kml_file_name character varying(255) NOT NULL
);


ALTER TABLE public.permitted_route OWNER TO postgres;

--
-- Name: permitted_route_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permitted_route_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permitted_route_id_seq OWNER TO postgres;

--
-- Name: permitted_route_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permitted_route_id_seq OWNED BY public.permitted_route.id;


--
-- Name: permitted_route_link; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.permitted_route_link (
    id integer NOT NULL,
    complex character varying(255) NOT NULL,
    car character varying(255),
    permitted_route_ids integer[] DEFAULT ARRAY[]::integer[] NOT NULL,
    created timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL
);


ALTER TABLE public.permitted_route_link OWNER TO postgres;

--
-- Name: permitted_route_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.permitted_route_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.permitted_route_link_id_seq OWNER TO postgres;

--
-- Name: permitted_route_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.permitted_route_link_id_seq OWNED BY public.permitted_route_link.id;


--
-- Name: resource_exists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resource_exists (
    id integer NOT NULL,
    type character varying(32) NOT NULL,
    exist boolean DEFAULT false NOT NULL,
    key character varying(64) NOT NULL,
    count bigint DEFAULT 0 NOT NULL,
    last_req timestamp with time zone DEFAULT now() NOT NULL,
    referer text
);


ALTER TABLE public.resource_exists OWNER TO postgres;

--
-- Name: resource_exists_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.resource_exists_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.resource_exists_id_seq OWNER TO postgres;

--
-- Name: resource_exists_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.resource_exists_id_seq OWNED BY public.resource_exists.id;


--
-- Name: resource_lock; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.resource_lock (
    resource_id character varying(32) NOT NULL,
    owner_id character varying(32) NOT NULL,
    expire timestamp without time zone NOT NULL
);


ALTER TABLE public.resource_lock OWNER TO postgres;

--
-- Name: role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role (
    id character varying(32) NOT NULL,
    name character varying(64)
);


ALTER TABLE public.role OWNER TO postgres;

--
-- Name: role_permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.role_permission (
    role_id character varying(32) NOT NULL,
    permission_id character varying(32) NOT NULL
);


ALTER TABLE public.role_permission OWNER TO postgres;

--
-- Name: sadis_contract; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sadis_contract (
    id integer NOT NULL,
    sadis_id character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    start_date timestamp with time zone NOT NULL,
    end_date timestamp with time zone NOT NULL,
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    geo_object_id integer,
    sadis_region_id character varying(255)[] DEFAULT (ARRAY[]::character varying[])::character varying(255)[] NOT NULL
);


ALTER TABLE public.sadis_contract OWNER TO postgres;

--
-- Name: COLUMN sadis_contract.sadis_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sadis_contract.sadis_id IS 'Id Контракта в Садис';


--
-- Name: COLUMN sadis_contract.start_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sadis_contract.start_date IS 'Дата начала контракта';


--
-- Name: COLUMN sadis_contract.end_date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sadis_contract.end_date IS 'Дата конца контракта';


--
-- Name: sadis_contract_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sadis_contract_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sadis_contract_id_seq OWNER TO postgres;

--
-- Name: sadis_contract_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sadis_contract_id_seq OWNED BY public.sadis_contract.id;


--
-- Name: sadis_interval; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sadis_interval (
    id character varying(64) NOT NULL,
    date date NOT NULL,
    start_date timestamp with time zone NOT NULL,
    end_date timestamp with time zone NOT NULL
);


ALTER TABLE public.sadis_interval OWNER TO postgres;

--
-- Name: COLUMN sadis_interval.id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sadis_interval.id IS 'Id месяца-года в Садис';


--
-- Name: COLUMN sadis_interval.date; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.sadis_interval.date IS 'Месяц – Год временного интервала';


--
-- Name: session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.session (
    id integer NOT NULL,
    ip character varying(64) NOT NULL,
    user_agent text NOT NULL,
    access_token character varying(255) NOT NULL,
    refresh_token character varying(255) NOT NULL,
    access_token_expire timestamp without time zone NOT NULL,
    refresh_token_expire timestamp without time zone NOT NULL,
    user_id integer NOT NULL,
    provider_id integer,
    real_user_id integer
);


ALTER TABLE public.session OWNER TO postgres;

--
-- Name: COLUMN session.provider_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.session.provider_id IS 'Провайдер авторизации пользователя. Его корневой scope. У пользователя не может быть привилегий больше чем у провайдера. Может отсутствовать, если пользователь авторизовался сам, а не через провайдера.';


--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    key character varying(255) NOT NULL,
    value text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: static_access; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.static_access (
    id integer NOT NULL,
    rule character varying(255) NOT NULL,
    sort integer DEFAULT 0 NOT NULL,
    permission_id character varying(32),
    create_date timestamp with time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_date timestamp with time zone DEFAULT now() NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.static_access OWNER TO postgres;

--
-- Name: TABLE static_access; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON TABLE public.static_access IS 'Доступ к статичным файлам';


--
-- Name: COLUMN static_access.permission_id; Type: COMMENT; Schema: public; Owner: postgres
--

COMMENT ON COLUMN public.static_access.permission_id IS 'Если null, то доступно без авторизации';


--
-- Name: static_access_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.static_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.static_access_id_seq OWNER TO postgres;

--
-- Name: static_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.static_access_id_seq OWNED BY public.static_access.id;


--
-- Name: subsystem; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.subsystem (
    id character varying(32) NOT NULL,
    name character varying(255) NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    base_url text DEFAULT ''::text NOT NULL
);


ALTER TABLE public.subsystem OWNER TO postgres;

--
-- Name: sync_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sync_data (
    node_id character varying(32) NOT NULL,
    node_url character varying(255),
    last_connection timestamp without time zone DEFAULT now() NOT NULL,
    last_sync timestamp without time zone DEFAULT now() NOT NULL,
    version character varying(32),
    log text
);


ALTER TABLE public.sync_data OWNER TO postgres;

--
-- Name: temporary_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.temporary_data (
    key character varying(32) NOT NULL,
    expires timestamp with time zone NOT NULL,
    data text DEFAULT '{}'::text
);


ALTER TABLE public.temporary_data OWNER TO postgres;

--
-- Name: user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public."user" (
    id integer NOT NULL,
    password character varying(255) NOT NULL,
    login character varying(255) NOT NULL,
    email character varying(255) NOT NULL,
    fio character varying,
    "position" character varying,
    organization character varying,
    secret character varying(255),
    enable boolean DEFAULT true NOT NULL
);


ALTER TABLE public."user" OWNER TO postgres;

--
-- Name: user_external_id; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_external_id (
    id integer NOT NULL,
    user_id integer NOT NULL,
    subsystem_id character varying(32) NOT NULL,
    external_id character varying(255) NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.user_external_id OWNER TO postgres;

--
-- Name: user_external_id_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_external_id_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_external_id_id_seq OWNER TO postgres;

--
-- Name: user_external_id_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_external_id_id_seq OWNED BY public.user_external_id.id;


--
-- Name: user_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_id_seq OWNER TO postgres;

--
-- Name: user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_id_seq OWNED BY public."user".id;


--
-- Name: user_online; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_online (
    id integer NOT NULL,
    session_id integer NOT NULL,
    node_id character varying(32) NOT NULL,
    connection_id character varying(32) NOT NULL,
    date timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.user_online OWNER TO postgres;

--
-- Name: user_online_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_online_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_online_id_seq OWNER TO postgres;

--
-- Name: user_online_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_online_id_seq OWNED BY public.user_online.id;


--
-- Name: user_permission; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_permission (
    user_id integer NOT NULL,
    permission_id character varying(32) NOT NULL
);


ALTER TABLE public.user_permission OWNER TO postgres;

--
-- Name: user_role; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_role (
    user_id integer NOT NULL,
    role_id character varying(32) NOT NULL
);


ALTER TABLE public.user_role OWNER TO postgres;

--
-- Name: user_session; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_session (
    id character varying(32) NOT NULL,
    user_id integer NOT NULL,
    end_time timestamp without time zone NOT NULL,
    ip character varying(64) NOT NULL,
    user_agent text NOT NULL,
    remember boolean DEFAULT false NOT NULL
);


ALTER TABLE public.user_session OWNER TO postgres;

--
-- Name: user_session_oauth2_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_session_oauth2_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_session_oauth2_id_seq OWNER TO postgres;

--
-- Name: user_session_oauth2_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_session_oauth2_id_seq OWNED BY public.session.id;


--
-- Name: user_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.user_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    key character varying(32) NOT NULL,
    value text NOT NULL
);


ALTER TABLE public.user_settings OWNER TO postgres;

--
-- Name: user_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.user_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.user_settings_id_seq OWNER TO postgres;

--
-- Name: user_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.user_settings_id_seq OWNED BY public.user_settings.id;


--
-- Name: validator; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.validator (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    schema text NOT NULL,
    schema_hash character varying(32) NOT NULL,
    data_example text NOT NULL,
    data_example_hash character varying(32) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.validator OWNER TO postgres;

--
-- Name: validator_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.validator_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.validator_id_seq OWNER TO postgres;

--
-- Name: validator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.validator_id_seq OWNED BY public.validator.id;


--
-- Name: validator_ver; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.validator_ver (
    id integer NOT NULL,
    validator_id integer NOT NULL,
    schema text NOT NULL,
    schema_hash character varying(32) NOT NULL,
    data_example text NOT NULL,
    data_example_hash character varying(32) NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL
);


ALTER TABLE public.validator_ver OWNER TO postgres;

--
-- Name: validator_ver_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.validator_ver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.validator_ver_id_seq OWNER TO postgres;

--
-- Name: validator_ver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.validator_ver_id_seq OWNED BY public.validator_ver.id;


--
-- Name: widget; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.widget (
    id character varying(32) NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    name character varying(255) DEFAULT ''::character varying NOT NULL,
    type character varying(32) NOT NULL,
    tags character varying(32)[] DEFAULT (ARRAY[]::character varying[])::character varying(32)[] NOT NULL,
    config text DEFAULT '{}'::text NOT NULL,
    permission_id character varying(32),
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    update_user_id integer NOT NULL
);


ALTER TABLE public.widget OWNER TO postgres;

--
-- Name: worker_cron; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.worker_cron (
    id integer NOT NULL,
    worker_id character varying(32) NOT NULL,
    worker_param text,
    next_update timestamp without time zone NOT NULL,
    interval_sec integer DEFAULT 60 NOT NULL,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    update_date timestamp without time zone DEFAULT now() NOT NULL,
    create_user_id integer NOT NULL,
    update_user_id integer NOT NULL,
    description text DEFAULT ''::text NOT NULL,
    enable boolean DEFAULT true NOT NULL,
    execution_time_min integer DEFAULT 0 NOT NULL,
    execution_time_max integer DEFAULT 0 NOT NULL,
    execution_time_average integer DEFAULT 0 NOT NULL,
    subwork_min integer DEFAULT 0 NOT NULL,
    subwork_max integer DEFAULT 0 NOT NULL,
    subwork_average integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.worker_cron OWNER TO postgres;

--
-- Name: worker_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.worker_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.worker_cron_id_seq OWNER TO postgres;

--
-- Name: worker_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.worker_cron_id_seq OWNED BY public.worker_cron.id;


--
-- Name: worker_cron_time_log; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.worker_cron_time_log (
    id integer NOT NULL,
    worker_id integer NOT NULL,
    start_time timestamp without time zone DEFAULT now() NOT NULL,
    end_time timestamp without time zone DEFAULT now() NOT NULL,
    subwork_count integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.worker_cron_time_log OWNER TO postgres;

--
-- Name: worker_cron_time_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.worker_cron_time_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.worker_cron_time_log_id_seq OWNER TO postgres;

--
-- Name: worker_cron_time_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.worker_cron_time_log_id_seq OWNED BY public.worker_cron_time_log.id;


--
-- Name: callback_event id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.callback_event ALTER COLUMN id SET DEFAULT nextval('public.callback_event_id_seq'::regclass);


--
-- Name: citizens_appeals id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.citizens_appeals ALTER COLUMN id SET DEFAULT nextval('public.citizens_appeals_id_seq'::regclass);


--
-- Name: comment id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comment ALTER COLUMN id SET DEFAULT nextval('public.comment_id_seq'::regclass);


--
-- Name: ct_override id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override ALTER COLUMN id SET DEFAULT nextval('public.ct_override_id_seq'::regclass);


--
-- Name: data_source_user_params id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params ALTER COLUMN id SET DEFAULT nextval('public.data_source_user_params_id_seq'::regclass);


--
-- Name: dc_event id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_event ALTER COLUMN id SET DEFAULT nextval('public.dc_event_id_seq'::regclass);


--
-- Name: dc_task id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_task ALTER COLUMN id SET DEFAULT nextval('public.dc_task_id_seq'::regclass);


--
-- Name: file id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file ALTER COLUMN id SET DEFAULT nextval('public.file_id_seq'::regclass);


--
-- Name: file_view id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file_view ALTER COLUMN id SET DEFAULT nextval('public.file_view_id_seq'::regclass);


--
-- Name: geo_object id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object ALTER COLUMN id SET DEFAULT nextval('public.geo_object_id_seq'::regclass);


--
-- Name: geo_object_ver id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object_ver ALTER COLUMN id SET DEFAULT nextval('public.geo_object_ver_id_seq'::regclass);


--
-- Name: logs id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logs ALTER COLUMN id SET DEFAULT nextval('public.logs_id_seq'::regclass);


--
-- Name: migrations_v2 id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations_v2 ALTER COLUMN id SET DEFAULT nextval('public.migrations_v2_id_seq'::regclass);


--
-- Name: notification id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.notification ALTER COLUMN id SET DEFAULT nextval('public.notification_id_seq'::regclass);


--
-- Name: object id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.object ALTER COLUMN id SET DEFAULT nextval('public.object_id_seq'::regclass);


--
-- Name: permitted_route id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permitted_route ALTER COLUMN id SET DEFAULT nextval('public.permitted_route_id_seq'::regclass);


--
-- Name: permitted_route_link id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permitted_route_link ALTER COLUMN id SET DEFAULT nextval('public.permitted_route_link_id_seq'::regclass);


--
-- Name: resource_exists id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resource_exists ALTER COLUMN id SET DEFAULT nextval('public.resource_exists_id_seq'::regclass);


--
-- Name: sadis_contract id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract ALTER COLUMN id SET DEFAULT nextval('public.sadis_contract_id_seq'::regclass);


--
-- Name: session id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session ALTER COLUMN id SET DEFAULT nextval('public.user_session_oauth2_id_seq'::regclass);


--
-- Name: static_access id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.static_access ALTER COLUMN id SET DEFAULT nextval('public.static_access_id_seq'::regclass);


--
-- Name: user id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user" ALTER COLUMN id SET DEFAULT nextval('public.user_id_seq'::regclass);


--
-- Name: user_external_id id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id ALTER COLUMN id SET DEFAULT nextval('public.user_external_id_id_seq'::regclass);


--
-- Name: user_online id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_online ALTER COLUMN id SET DEFAULT nextval('public.user_online_id_seq'::regclass);


--
-- Name: user_settings id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_settings ALTER COLUMN id SET DEFAULT nextval('public.user_settings_id_seq'::regclass);


--
-- Name: validator id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator ALTER COLUMN id SET DEFAULT nextval('public.validator_id_seq'::regclass);


--
-- Name: validator_ver id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator_ver ALTER COLUMN id SET DEFAULT nextval('public.validator_ver_id_seq'::regclass);


--
-- Name: worker_cron id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron ALTER COLUMN id SET DEFAULT nextval('public.worker_cron_id_seq'::regclass);


--
-- Name: worker_cron_time_log id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron_time_log ALTER COLUMN id SET DEFAULT nextval('public.worker_cron_time_log_id_seq'::regclass);


--
-- Data for Name: adapter; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.adapter (id, name, type, permission_id, enable, config, create_date, update_date, create_user_id, update_user_id) FROM stdin;
\.


--
-- Data for Name: callback_event; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.callback_event (id, uid, object_id, type, title, message, images, create_date) FROM stdin;
\.


--
-- Data for Name: citizens_appeals; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.citizens_appeals (id, fio, phone, email, message, ip, user_agent, create_date) FROM stdin;
\.


--
-- Data for Name: comment; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.comment (id, message, create_date, update_date, object_type, object_id, create_user_id, update_user_id, title, link) FROM stdin;
\.


--
-- Data for Name: ct_override; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.ct_override (id, enable, data_type, subsystem_id, data_id, set, value_type, value, create_date, update_date, create_user_id, update_user_id) FROM stdin;
\.


--
-- Data for Name: dashboard; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dashboard (id, name, read_perm_id, edit_perm_id, is_private, enable, config, create_date, update_date, create_user_id, update_user_id) FROM stdin;
\.


--
-- Data for Name: data_source; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.data_source (id, subsystem_id, protocol, description, config, params, permission_id, create_date, update_date, create_user_id, update_user_id, credentials, auth_type, credentials_next_update, enable, user_params) FROM stdin;
api	api	http	АПИ	{"auth":{"type":"this"},"domain":"http://its-frontend-tambov:8000/","getData":{},"headers":{},"type":"http"}	hfI=	\N	2025-07-09 16:40:17.318	2025-07-09 17:22:13.221	3	3	\N	this	\N	t	f
\.


--
-- Data for Name: data_source_query; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.data_source_query (id, data_source_id, validator_id, description, config, log_enable, log_weight, log_limit_size, log_limit_max, log_stat_count1h, log_stat_count2h, log_stat_count4h, log_stat_size, log_stat_count, log_stat_errors1h, permission_id, create_date, update_date, create_user_id, update_user_id, enable) FROM stdin;
api_ct_actual_data	api	\N	Общие типы, актуальные данные из подсистемы	{"getData":{},"headers":{},"method":"POST","params":[{"name":"dataType","type":"string"}],"postData":{"data":"{\\n  \\"dataType\\": {{dataType}},\\n  \\"filter\\": {}\\n}","type":"json"},"respType":"json","ttl":300,"type":"http","uri":"/api/ct/actual-data"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:17.521	2025-07-09 16:40:17.521	3	3	t
api_ct_actual_data_subsystem	api	\N	Общие типы, актуальные данные из подсистемы	{"getData":{},"headers":{},"method":"POST","params":[{"name":"dataType","type":"string"},{"name":"subsystemId","type":"string"}],"postData":{"data":"{\\n  \\"dataType\\": {{dataType}},\\n  \\"filter\\": {\\n    \\"subsystemId\\" : {\\n      \\"$eq\\": {{subsystemId}}\\n    }\\n  }\\n}","type":"json"},"respType":"json","ttl":300,"type":"http","uri":"/api/ct/actual-data"}	t	1	10485760	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:21.163	2025-07-09 16:40:21.163	3	3	t
api_ct_find	api	\N	Общие типы, актуальные данные из подсистемы	{"getData":{},"headers":{},"method":"POST","params":[{"name":"subsystemId","type":"string"},{"name":"dataType","type":"string"}],"postData":{"data":"{\\n  \\"dataType\\": {{dataType}},\\n  \\"history\\": false,\\n  \\"filter\\": {\\n    \\"subsystemId\\": {\\n      \\"$eq\\": {{subsystemId}}\\n    }\\n  },\\n  \\"perPage\\": 1000\\n}","type":"json"},"respType":"json","ttl":300,"type":"http","uri":"/api/ct/find"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:21.372	2025-07-09 16:40:21.372	3	3	t
api_ct_netvision_list	api	\N	Общие типы, список камер нетвижен	{"getData":{},"headers":{},"method":"POST","params":[],"postData":{"data":"{\\n  \\"dataType\\": \\"camera_list\\",\\n  \\"history\\": false,\\n  \\"filter\\": {\\n    \\"subsystemId\\": {\\n      \\"$eq\\": \\"netvision\\"\\n    }\\n  },\\n  \\"perPage\\": 1000\\n}","type":"json"},"respType":"json","ttl":300,"type":"http","uri":"/api/ct/find"}	t	1	10485760	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:24.961	2025-07-09 16:40:24.961	3	3	t
api_ct_sadis_get_road	api	\N	Садис, список работ по дорогам	{"getData":{},"headers":{},"method":"POST","params":[],"postData":{"data":"{\\n  \\"dataType\\": \\"special\\",\\n  \\"history\\": false,\\n  \\"filter\\": {\\n    \\"subsystemId\\": \\"sadis\\",\\n    \\"data.req\\": \\"sadis_get_road\\"\\n  },\\n  \\"perPage\\": 1000000\\n}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/api/ct/find"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:25.101	2025-07-09 16:40:25.101	3	3	t
api_sc_montp_detector_list	api	\N	Детекторы МОНТП	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":300,"type":"http","uri":"/static-cache/montp/detector/list.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:28.825	2025-07-09 16:40:28.825	3	3	t
api_sc_predobr_device_list	api	\N	Предобработка список устройств	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/predobr/device_list.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:32.473	2025-07-09 16:40:32.473	3	3	t
api_sc_titul_road2repair	api	\N	Дороги Титул	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/titul/roads_to_repair.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:36.129	2025-07-09 16:40:36.13	3	3	t
api_sc_titul_road_history	api	\N	Дороги Титул	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/titul/road_history.json"}	t	1	10485760	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:39.729	2025-07-09 16:40:39.729	3	3	t
api_sc_titul_road_list	api	\N	Дороги Титул	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/titul/road_list.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:39.891	2025-07-09 16:40:39.891	3	3	t
api_sc_titul_road_repaired_list	api	\N	Протяженность ремонтируемых участков	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/radis/repaired_areas/list.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:40.066	2025-07-09 16:40:40.066	3	3	t
api_sc_vgk_device_list	api	\N	Список ВГК	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"data":"{}","type":"json"},"respType":"json","ttl":0,"type":"http","uri":"/static-cache/vgk/device/list.json"}	t	1	52428800	1000	0	0	0	0	0	0	\N	2025-07-09 16:40:40.234	2025-07-09 16:40:40.234	3	3	t
api_settings_list	api	1	Получить настройки	{"getData":{},"headers":{},"method":"GET","params":[],"postData":{"type":"json","data":"{}"},"respType":"json","ttl":0,"type":"http","uri":"/api/settings/list"}	t	1	10485760	1000	0	0	0	2647	3	0	\N	2025-07-09 16:40:40.398	2025-07-09 17:22:29.688	3	3	t
\.


--
-- Data for Name: data_source_user_params; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.data_source_user_params (id, user_id, data_source_id, enable, params, credentials, create_date, create_user_id, update_date, update_user_id, credentials_next_update) FROM stdin;
\.


--
-- Data for Name: dc_config; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_config (id, enable, data_type, "interval", name, description, config, create_user_id, update_user_id, create_date, update_date, actual_data, scanning_depth, delete) FROM stdin;
\.


--
-- Data for Name: dc_config_subsystem; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_config_subsystem (dc_config_id, subsystem_id) FROM stdin;
\.


--
-- Data for Name: dc_event; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_event (id, dc_config_id, date, data_id, data, status, log, dc_config, create_date, description) FROM stdin;
\.


--
-- Data for Name: dc_flag; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_flag (id, name, description, enable, tags, create_date, update_date, create_user_id, update_user_id) FROM stdin;
\.


--
-- Data for Name: dc_flag_device; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_flag_device (id, dc_flag_id, data_type, subsystem_id, device_id, status, lvl, reason, expiries, date, user_id, dc_config_id, dc_task_id) FROM stdin;
\.


--
-- Data for Name: dc_task; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.dc_task (id, dc_event_id, parent_id, parent_status, type, config, status, next_repeat_date, lock_id, lock_expires, repetitions_left, repetition_interval, error, create_date, update_date) FROM stdin;
\.


--
-- Data for Name: file; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.file (id, parent_id, is_dir, name, description, ext, icon_id, hash, size, quota, file_count, perm_c, perm_r, perm_u, perm_d, create_date, update_date, create_user_id, update_user_id) FROM stdin;
1	\N	t	Файлы	\N		\N	\N	0	0	0	\N	\N	\N	\N	2000-01-01 00:00:00	2000-01-01 00:00:00	\N	\N
\.


--
-- Data for Name: file_view; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.file_view (id, file_id, user_id, state) FROM stdin;
\.


--
-- Data for Name: form; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.form (id, title, description, config, perm_c, perm_r, perm_u, perm_d, create_date, create_user_id, update_date, update_user_id) FROM stdin;
\.


--
-- Data for Name: geo_collection; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.geo_collection (id, name, description, perm_r, perm_u, has_key, has_perm, has_meta, has_tags) FROM stdin;
common	Общие	Геообъекты общего назначения необходимые для функционирования ИТС	\N	\N	t	f	f	f
\.


--
-- Data for Name: geo_object; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.geo_object (id, collection_id, key, name, description, geometry, geometry_type, geometry_bounds, geometry_hash, permission_id, create_date, update_date, create_user_id, update_user_id, data_type, enable, meta, tags) FROM stdin;
1	common	region	region		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	Polygon	0103000020E610000001000000050000005C92037635F5434083A6255646CB494008C89750C19F454083A6255646CB494008C89750C19F45408DB800344AE94A405C92037635F543408DB800344AE94A405C92037635F5434083A6255646CB4940	4f4c21ac30fe3b32d2ca49547f06ab9b	\N	2025-07-09 16:45:57.81	2025-07-09 16:48:30.496	3	3	{}	t	{}	{}
\.


--
-- Data for Name: geo_object_ver; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.geo_object_ver (id, geometry, geometry_type, geometry_bounds, geometry_hash, create_date, create_user_id, geo_object_id) FROM stdin;
1	{"type":"Polygon","coordinates":[[[39.915694,52.708851],[39.943654,52.732841],[39.973208,52.730645],[39.961778,52.747758],[39.980173,52.752728],[39.990406,52.737825],[40.020072,52.736319],[40.050286,52.751214],[40.023805,52.772478],[40.032364,52.775955],[40.051221,52.770874],[40.058042,52.752782],[40.083271,52.754594],[40.064398,52.784916],[40.090443,52.783203],[40.097894,52.80043],[40.095751,52.879469],[40.037174,52.894046],[40.037574,52.912903],[40.071267,52.924749],[40.079528,52.94753],[40.121183,52.940314],[40.124769,52.957037],[40.112197,52.965997],[40.124847,52.980401],[40.074883,53.004513],[40.124545,53.022175],[40.157263,53.053329],[40.134811,53.105973],[40.139899,53.137839],[40.120603,53.144519],[40.13027,53.152307],[40.117357,53.172124],[40.129976,53.168562],[40.108309,53.211004],[40.087045,53.213545],[40.103159,53.221962],[40.096981,53.275728],[40.113129,53.274845],[40.123552,53.294858],[40.152171,53.295393],[40.157788,53.312512],[40.21311,53.310452],[40.233351,53.352698],[40.26164,53.335877],[40.272968,53.376786],[40.300817,53.381963],[40.301546,53.362491],[40.370296,53.33974],[40.403064,53.388667],[40.425341,53.388177],[40.408243,53.461938],[40.428878,53.476217],[40.422192,53.496456],[40.462568,53.483463],[40.471376,53.444638],[40.547002,53.467162],[40.541615,53.477975],[40.554763,53.492579],[40.599096,53.50773],[40.641924,53.501046],[40.639908,53.522227],[40.656005,53.539598],[40.680431,53.538486],[40.700911,53.556151],[40.756294,53.553084],[40.779705,53.548264],[40.771327,53.524915],[40.802984,53.520039],[40.814685,53.483796],[40.839694,53.457597],[40.896231,53.505344],[40.958032,53.500083],[41.042897,53.476447],[41.051906,53.452282],[41.03991,53.429778],[41.144903,53.41667],[41.186856,53.439684],[41.185909,53.472949],[41.259871,53.471056],[41.247266,53.516356],[41.279981,53.510664],[41.353868,53.525427],[41.368501,53.687677],[41.363107,53.766211],[41.397473,53.769588],[41.399743,53.783737],[41.497965,53.772778],[41.554343,53.811923],[41.603982,53.802626],[41.599911,53.793193],[41.613882,53.791558],[41.60658,53.777002],[41.619744,53.773359],[41.657337,53.784107],[41.649135,53.801959],[41.675683,53.799906],[41.686799,53.812343],[41.802991,53.804635],[41.868474,53.822224],[41.982956,53.803329],[42.02433,53.822577],[42.058823,53.803032],[42.14363,53.802798],[42.154048,53.77081],[42.106717,53.768021],[42.110404,53.75708],[42.081739,53.748005],[42.089521,53.708587],[42.143951,53.712079],[42.117835,53.671193],[42.131121,53.654039],[42.121927,53.569092],[42.140302,53.569282],[42.109533,53.515339],[42.171746,53.532993],[42.167216,53.515333],[42.14077,53.498697],[42.197589,53.496055],[42.227419,53.479705],[42.255533,53.485339],[42.262907,53.463039],[42.297296,53.451342],[42.299252,53.432534],[42.320426,53.429745],[42.259801,53.414553],[42.236842,53.359372],[42.291964,53.372906],[42.356524,53.32809],[42.412166,53.33802],[42.419006,53.287923],[42.43218,53.283097],[42.420968,53.271701],[42.504045,53.234619],[42.571364,53.179832],[42.509028,53.17019],[42.547553,53.122359],[42.627415,53.127872],[42.778715,53.00415],[42.95262,52.933564],[42.952816,52.911953],[43.091832,52.810013],[43.11827,52.803298],[43.202944,52.708771],[43.248087,52.63634],[43.220343,52.636794],[43.112444,52.570529],[43.092381,52.576031],[43.058242,52.559391],[43.054564,52.523976],[43.121771,52.510893],[43.024048,52.486763],[43.048908,52.440327],[43.081442,52.412738],[43.066872,52.402483],[43.072117,52.391566],[43.038936,52.3879],[43.035139,52.357967],[43.01622,52.352734],[42.920796,52.360329],[42.942237,52.336069],[42.889762,52.247165],[42.888845,52.21206],[42.845065,52.210501],[42.844954,52.200774],[42.7719,52.184973],[42.778843,52.171099],[42.763947,52.135975],[42.773827,52.127442],[42.756828,52.085479],[42.785429,52.073074],[42.775907,52.062013],[42.790464,52.059179],[42.776241,52.041633],[42.813583,52.022217],[42.764605,52.018015],[42.713197,51.996037],[42.717222,51.97035],[42.731363,51.96612],[42.71015,51.949773],[42.712606,51.88562],[42.682054,51.84889],[42.667717,51.80689],[42.516938,51.713077],[42.504041,51.665184],[42.520818,51.596427],[42.499404,51.592774],[42.482818,51.631369],[42.425604,51.623934],[42.376547,51.592683],[42.344293,51.588084],[42.298351,51.619261],[42.265279,51.601657],[42.282139,51.640263],[42.268373,51.662683],[42.309921,51.673056],[42.307823,51.689623],[42.274741,51.68584],[42.228991,51.718956],[42.189914,51.723724],[42.194891,51.707057],[42.119116,51.730476],[42.106385,51.717498],[42.125916,51.702071],[42.107307,51.692919],[42.139296,51.63046],[42.095028,51.628202],[42.070393,51.657517],[42.020898,51.668015],[41.998627,51.654124],[41.896833,51.680088],[41.838889,51.67403],[41.842268,51.69425],[41.855538,51.693661],[41.853829,51.713784],[41.79207,51.708261],[41.784364,51.718257],[41.733194,51.70581],[41.722845,51.735944],[41.635827,51.73294],[41.599846,51.765405],[41.513088,51.776613],[41.506951,51.799619],[41.482191,51.804557],[41.461734,51.799378],[41.481703,51.769808],[41.306912,51.80154],[41.3029,51.788803],[41.280708,51.791969],[41.296199,51.738301],[41.116278,51.730219],[41.119307,51.719107],[41.062902,51.720342],[41.056181,51.736312],[41.007043,51.715942],[41.009629,51.726158],[40.991669,51.72515],[40.998866,51.734667],[40.969124,51.746452],[40.882038,51.738718],[40.928766,51.817667],[40.917884,51.828317],[40.948362,51.8607],[40.945261,51.891226],[40.925488,51.887958],[40.845697,51.921982],[40.803902,51.894471],[40.752964,51.937303],[40.53414,51.945692],[40.533897,51.977305],[40.545416,51.991086],[40.536676,52.008933],[40.641422,52.036222],[40.644101,52.053124],[40.613192,52.05454],[40.627108,52.089254],[40.590303,52.091979],[40.612109,52.101811],[40.590498,52.112524],[40.610069,52.109992],[40.625935,52.144561],[40.650469,52.139001],[40.642537,52.158498],[40.655454,52.164534],[40.637032,52.174902],[40.66195,52.190266],[40.701571,52.188767],[40.684615,52.202932],[40.696304,52.229732],[40.71166,52.228739],[40.744072,52.19361],[40.764775,52.201607],[40.733335,52.224173],[40.741357,52.22519],[40.733435,52.251247],[40.660279,52.285884],[40.611198,52.281068],[40.590336,52.257397],[40.572258,52.27767],[40.563626,52.332262],[40.505614,52.328857],[40.512791,52.354903],[40.376023,52.360889],[40.354691,52.366161],[40.355599,52.383839],[40.293363,52.391964],[40.281917,52.415982],[40.296317,52.441296],[40.330291,52.44204],[40.325873,52.458656],[40.272276,52.453063],[40.214266,52.467058],[40.226615,52.500961],[40.173294,52.502199],[40.124275,52.551432],[40.114642,52.540056],[40.063483,52.562392],[40.046365,52.545786],[40.019627,52.564738],[40.045105,52.589354],[39.976678,52.596802],[39.971531,52.624179],[39.949503,52.63353],[39.955811,52.650025],[39.946132,52.659179],[39.960238,52.668856],[39.982138,52.655944],[39.987347,52.677187],[39.931449,52.699224],[39.938758,52.708237],[39.915694,52.708851]]]}	Polygon	{"type":"Polygon","coordinates":[[[39.915694,51.588084],[43.248087,51.588084],[43.248087,53.822577],[39.915694,53.822577],[39.915694,51.588084]]]}	4f4c21ac30fe3b32d2ca49547f06ab9b	2025-07-09 16:45:57.81	3	1
\.


--
-- Data for Name: link; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.link (id, text_ru, text_en, uri, log_msg, permission_id) FROM stdin;
index	Стартовая страница		/	\N	\N
\.


--
-- Data for Name: logs; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.logs (id, message, create_date, user_id, ip, subsystem_id, action, data_id, before, after, real_user_id, sign, sign_prev, sign_next) FROM stdin;
158	Пользователь administrator авторизован	2025-12-18 09:25:33.405+00	3	172.18.0.1	api	login	3	\N	{"flow":"password","userId":3,"login":"administrator"}	\N	\\x957752264456d7df772f52cdcce8ce84	\\x8c25ca72b719684cbc9ca7ab071f2b26	\N
157	Пользователь administrator авторизован	2025-12-18 09:12:36.743+00	3	172.18.0.1	api	login	3	\N	{"flow":"password","userId":3,"login":"administrator"}	\N	\\x9ab789edc8b4acfafb32486a1dacd212	\N	\\x5d18a61b145832920a66ad259dd089b7
\.


--
-- Data for Name: migrations_v2; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.migrations_v2 (id, "timestamp", name) FROM stdin;
1	1000000000000	migration1000000000000
2	1000000000100	migration1000000000100
3	1000000000200	migration1000000000200
4	1000000000300	migration1000000000300
5	1000000000400	migration1000000000400
6	1000000000500	migration1000000000500
7	1000000000600	migration1000000000600
8	1000000000700	migration1000000000700
9	1000000000800	migration1000000000800
10	1000000000900	migration1000000000900
11	1000000001000	migration1000000001000
12	1000000001100	migration1000000001100
13	1000000001200	migration1000000001200
14	1000000001300	migration1000000001300
15	1000000001400	migration1000000001400
16	1000000002000	migration1000000002000
17	1000000002100	migration1000000002100
18	1000000002200	migration1000000002200
19	1000000003000	migration1000000003000
20	1000000003100	migration1000000003100
21	1000000003200	migration1000000003200
22	1000000003300	migration1000000003300
23	1000000003400	migration1000000003400
24	1000000003500	migration1000000003500
25	1000000003600	migration1000000003600
26	1000000003700	migration1000000003700
27	1000000003800	migration1000000003800
28	1000000003900	migration1000000003900
29	1000000004000	migration1000000004000
30	1000000004100	migration1000000004100
31	1000000004200	migration1000000004200
32	1000000004300	migration1000000004300
33	1000000004400	migration1000000004400
34	1000000004600	migration1000000004600
35	1000000004601	migration1000000004601
36	1000000004700	migration1000000004700
37	1000000004900	migration1000000004900
38	1000000005301	migration1000000005301
39	1000000005400	migration1000000005400
40	1000000005600	migration1000000005600
41	1000000005700	migration1000000005700
42	1000000005800	migration1000000005800
43	1000000005900	migration1000000005900
44	1000000006000	migration1000000006000
45	1000000006100	migration1000000006100
46	1000000006300	migration1000000006300
47	1000000006400	migration1000000006400
48	1000000006500	migration1000000006500
49	1000000006600	migration1000000006600
50	1000000006700	migration1000000006700
51	1000000006901	migration1000000006901
52	1000000007000	migration1000000007000
53	1000000007100	migration1000000007100
54	1000000007200	migration1000000007200
55	1000000007300	migration1000000007300
56	1000000007400	migration1000000007400
57	1000000007500	migration1000000007500
58	1000000007600	migration1000000007600
59	1000000007700	migration1000000007700
60	1000000007800	migration1000000007800
61	1000000007900	migration1000000007900
62	1000000008000	migration1000000008000
63	1000000008100	migration1000000008100
64	1000000008200	migration1000000008200
65	1000000008300	migration1000000008300
66	1000000008400	migration1000000008400
67	1000000008500	migration1000000008500
68	1000000008600	migration1000000008600
69	1000000008700	migration1000000008700
70	1000000008800	migration1000000008800
71	1000000008900	migration1000000008900
72	1000000009000	migration1000000009000
73	1000000009100	migration1000000009100
74	1000000009200	migration1000000009200
75	1000000010000	migration1000000010000
76	1000000011000	migration1000000011000
77	1000000012000	migration1000000012000
78	1000000013000	migration1000000013000
79	1000000014000	migration1000000014000
80	1000000015000	migration1000000015000
81	1000000016000	migration1000000016000
82	1000000017000	migration1000000017000
83	1000000018000	migration1000000018000
84	1000000019000	migration1000000019000
85	1000000020000	migration1000000020000
86	1000000021000	migration1000000021000
87	1000000022002	migration1000000022002
88	1000000023002	migration1000000023002
89	1000000024001	migration1000000024001
90	1000000025001	migration1000000025001
91	1000000026001	migration1000000026001
92	1000000027001	migration1000000027001
93	1000000028000	migration1000000028000
94	1000000029000	migration1000000029000
95	1010000000000	migration1010000000000
96	1010000000100	migration1010000000100
97	1010000000200	migration1010000000200
98	1010000000300	migration1010000000300
99	1010000000310	migration1010000000310
100	1010000000320	migration1010000000320
101	1010000000330	migration1010000000330
102	1010000000400	migration1010000000400
103	1010000000500	migration1010000000500
104	1010000000600	migration1010000000600
105	1010000000700	migration1010000000700
106	1010000000802	migration1010000000802
107	1010000000900	migration1010000000900
\.


--
-- Data for Name: module; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.module (id, name, type, enable, config, create_date, update_date, create_user_id, update_user_id, is_private, read_perm_id, edit_perm_id, sort) FROM stdin;
index	Элементы ИТС	map_with_layers	t	{"type":"map_with_layers","icon":"geoCursor","showInMenu":true,"dateFilter":"none","baskButton":false,"reports":false,"register":false,"layers":[],"widgets":[]}	2025-07-09 17:39:47.079495	2025-07-09 19:21:36.341	1	1	f	\N	\N	1000
\.


--
-- Data for Name: notification; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.notification (id, external_id, type, tags, lvl, title, message, link, data, created, expiry, images, button_config) FROM stdin;
\.


--
-- Data for Name: notification_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.notification_user (user_id, notification_id, state) FROM stdin;
\.


--
-- Data for Name: object; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.object (id, type, entity_id, tags, name, object, create_date, create_user_id, update_date, update_user_id) FROM stdin;
\.


--
-- Data for Name: permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.permission (id, name, subsystem_id) FROM stdin;
admin:dashboard	Администрирование дашбордов	api
admin:profiler2	Профилировщик в заголовке	api
admin:link_list	Просмотр ссылок	api
admin:we	Редактирование виджетов	api
all:see_warning	Всплывающие предупреждения	api
module:root	Модули	api
admin:adapt:e	Редактирование адаптеров	api
admin:adapt:l	Просмотр адаптеров	api
admin:geo:all	Видеть все геообъекты игнорируя привилегии на них	api
admin:imp	Авторизация под любым пользователем	api
admin:sa	Администрирование прав доступа к статичному кэшу	api
admin:wl	Просмотр виджетов	api
all:root	Все модули	api
admin:root	Администрирование ИТС	api
all:see_errors	Может видеть сообщения об ошибках	api
comments:root	Написание комментариев	api
dashboard:root	Дашборд	api
all:modules	Модули	api
all:user	Авторизированный пользователь	api
admin:ds_list	Просмотр источников данных	api
admin:ds_edit	Редактирование источников данных	api
admin:geo	Может редактировать гео справочник	api
admin:geo:all_coll	Видеть все коллекции геообъектов	api
admin:profiler	Доступ в профилировщик	api
admin:link_edit	Редактирование ссылок	api
admin:sf	Администрирование статичного кэша	api
admin:missing	Раздел "Отсутствующие компоненты"	api
all:online2	Пользователи онлайн в заголовке	api
admin:cron_list	Просмотр фоновых задач	api
admin:cron_edit	Изменение фоновых задач	api
admin:user_list	Может видеть список пользователей	api
admin:user_edit	Может редактировать список пользователей	api
admin:role_list	Может видеть список ролей	api
admin:role_edit	Может редактировать список ролей	api
admin:perm_list	Может видеть список привилегий	api
admin:perm_edit	Может редактировать список привилегий	api
admin:module	Может видеть и редактировать все модули	api
db_my:root	Настраиваемый дашборд	api
admin:sc:e	Может редактировать 'Функционирование ИТС'	api
admin:sc:l	Может видеть 'Функционирование ИТС'	api
admin:db	Администрирование базы данных	api
admin:dev	Программист	api
admin:log2	Просмотр лога консольных команд	api
admin:log	Просмотр системных логов	api
admin:rle	Редактирование блокировки ресурса	api
admin:geo:key	Создавать ключи для геообъектов	api
admin:s6s	Редактирование конфигурации ИТС	api
\.


--
-- Data for Name: permitted_route; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.permitted_route (id, name, data, data_hash, created, create_user_id, kml_hash, kml_name, kml_file_name) FROM stdin;
\.


--
-- Data for Name: permitted_route_link; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.permitted_route_link (id, complex, car, permitted_route_ids, created, create_user_id) FROM stdin;
\.


--
-- Data for Name: resource_exists; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.resource_exists (id, type, exist, key, count, last_req, referer) FROM stdin;
\.


--
-- Data for Name: resource_lock; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.resource_lock (resource_id, owner_id, expire) FROM stdin;
MongoMigrate	1	2025-12-18 09:33:59.810918
\.


--
-- Data for Name: role; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.role (id, name) FROM stdin;
admin	admin
user	Пользователь
\.


--
-- Data for Name: role_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.role_permission (role_id, permission_id) FROM stdin;
user	all:modules
user	all:root
user	all:see_errors
user	all:see_warning
user	all:user
user	comments:root
user	dashboard:root
user	db_my:root
user	module:root
admin	admin:adapt:e
admin	admin:adapt:l
admin	admin:cron_edit
admin	admin:cron_list
admin	admin:dashboard
admin	admin:db
admin	admin:ds_edit
admin	admin:ds_list
admin	admin:geo
admin	admin:geo:all_coll
admin	admin:geo:key
admin	admin:imp
admin	admin:link_edit
admin	admin:link_list
admin	admin:log
admin	admin:log2
admin	admin:missing
admin	admin:module
admin	admin:perm_edit
admin	admin:perm_list
admin	admin:profiler
admin	admin:profiler2
admin	admin:rle
admin	admin:role_edit
admin	admin:role_list
admin	admin:root
admin	admin:s6s
admin	admin:sa
admin	admin:sc:e
admin	admin:sc:l
admin	admin:sf
admin	admin:user_edit
admin	admin:user_list
admin	admin:we
admin	admin:wl
admin	all:modules
admin	all:online2
admin	all:root
admin	all:see_errors
admin	all:see_warning
admin	all:user
admin	comments:root
admin	dashboard:root
admin	db_my:root
\.


--
-- Data for Name: sadis_contract; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sadis_contract (id, sadis_id, name, start_date, end_date, create_date, update_date, create_user_id, update_user_id, geo_object_id, sadis_region_id) FROM stdin;
\.


--
-- Data for Name: sadis_interval; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sadis_interval (id, date, start_date, end_date) FROM stdin;
\.


--
-- Data for Name: session; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.session (id, ip, user_agent, access_token, refresh_token, access_token_expire, refresh_token_expire, user_id, provider_id, real_user_id) FROM stdin;
14	172.18.0.1	Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36	eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MywidiI6ImNiYmYzZjI4MWIwMTRmOWJhYTI5ZmQ1N2I5NmEyYTE0IiwiaWF0IjoxNzY2MDQ5MTU2LCJleHAiOjE3NjYxMzU1NTZ9.lztvr9lorDBrM7M-f3pM-Wfc4pjQirJ1YViDcMGH-4A	eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MywidiI6ImNiYmYzZjI4MWIwMTRmOWJhYTI5ZmQ1N2I5NmEyYTE0IiwiaWF0IjoxNzY2MDQ5MTU2LCJleHAiOjE3Njg2NDExNTZ9.W8LFSsMGJsNtGmDIigHTJNQi20uVt4jcc42THFUpytg	2025-12-19 09:12:36.766	2026-01-17 09:12:36.766	3	\N	\N
15	172.18.0.1	Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36	eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MywidiI6IjJlNGEzMmYxMWE5MzQ0Yjc5ODdmYjgzYTY4ZmQxOWQ3IiwiaWF0IjoxNzY2MDQ5OTMzLCJleHAiOjE3NjYxMzYzMzN9.l6UrkfCZ7y3yNF_hoohmwkDxIqhDAxXJztWPrHxfv-M	eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6MywidiI6IjJlNGEzMmYxMWE5MzQ0Yjc5ODdmYjgzYTY4ZmQxOWQ3IiwiaWF0IjoxNzY2MDQ5OTMzLCJleHAiOjE3Njg2NDE5MzN9.zndV65ag5nCXPwLEj41KE61y1Ri8n0vjNjmfrU1gTrQ	2025-12-19 09:25:33.43	2026-01-17 09:25:33.43	3	\N	\N
\.


--
-- Data for Name: settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.settings (key, value) FROM stdin;
SELF_CONTROL_LIMIT	0.8
ROAD_ACCIDENTS_LIMIT	100
MAP_CENTER	{"zoom":8,"lat":52.7,"lng":41.6}
SELF_CONTROL_STATE	REGULAR_MODE
PAGE_AFTER_LOGIN	/
\.


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.spatial_ref_sys (srid, auth_name, auth_srid, srtext, proj4text) FROM stdin;
\.


--
-- Data for Name: static_access; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.static_access (id, rule, sort, permission_id, create_date, create_user_id, update_date, update_user_id) FROM stdin;
1	/**	100	all:user	2025-07-09 15:32:40.924484+00	1	2025-07-09 15:32:40.924484+00	1
2	/config/**	200	\N	2025-07-09 18:36:36.183+00	1	2025-07-09 18:36:36.183+00	1
3	/export/**	300	\N	2025-07-09 18:36:51.507+00	1	2025-07-09 18:36:51.507+00	1
\.


--
-- Data for Name: subsystem; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.subsystem (id, name, description, base_url) FROM stdin;
api	ИТС	Интелектуальная транспортная система	
\.


--
-- Data for Name: sync_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.sync_data (node_id, node_url, last_connection, last_sync, version, log) FROM stdin;
\.


--
-- Data for Name: temporary_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.temporary_data (key, expires, data) FROM stdin;
\.


--
-- Data for Name: user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public."user" (id, password, login, email, fio, "position", organization, secret, enable) FROM stdin;
1	4edd00df0940650c0ae330a7e6d6795f7d69594aa26916fb7a58eeefb84e8c7bf0c9264a57b4f812515d63553ae745ffbdfe7babd896fa369a1cb509ba091edc	arybalko	arybalko@angelsit.ru	Рыбалко А.М.	Архитектор ПО	Ангелы ИТ	zuLPe99MzX0vIkNJNhk2JIA4rgSkSChT8XfbCB/799s=	t
3	5e6874ff94df17e9a2eab7c386431da739d81cd6297514407dae98e9d6ccc74e4fd7ecc01e3f247e41baa03d95f59e67e70215c66825fc1ff616e0c81eccc1a1	administrator	administrator@angelsit.ru	administrator	administrator		n7zHMapFxwsBYhcTQV0cIfA2jxi3fDJN93HNFWzxwuI=	t
\.


--
-- Data for Name: user_external_id; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_external_id (id, user_id, subsystem_id, external_id, create_user_id, update_user_id, create_date, update_date) FROM stdin;
\.


--
-- Data for Name: user_online; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_online (id, session_id, node_id, connection_id, date) FROM stdin;
\.


--
-- Data for Name: user_permission; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_permission (user_id, permission_id) FROM stdin;
1	admin:dev
\.


--
-- Data for Name: user_role; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_role (user_id, role_id) FROM stdin;
3	admin
3	user
1	admin
1	user
\.


--
-- Data for Name: user_session; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_session (id, user_id, end_time, ip, user_agent, remember) FROM stdin;
\.


--
-- Data for Name: user_settings; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.user_settings (id, user_id, key, value) FROM stdin;
\.


--
-- Data for Name: validator; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.validator (id, name, schema, schema_hash, data_example, data_example_hash, create_date, update_date, create_user_id, update_user_id) FROM stdin;
1	api_settings_list	{"items":{"properties":{"key":{"type":"string"},"value":{"type":"string"}},"required":["key","value"],"type":"object"},"type":"array"}	dc08164fede94254ef095f532764ccb7	[{"key":"SELF_CONTROL_LIMIT","value":"0.8"},{"key":"ROAD_ACCIDENTS_LIMIT","value":"100"},{"key":"SELF_CONTROL_STATE","value":"EMERGENCY_MODE"},{"key":"MAP_CENTER","value":"{\\"zoom\\":8,\\"lat\\":52.7,\\"lng\\":41.6}"}]	8bc200717dc1c06f9a83b62f0f8f85c6	2025-07-09 17:22:29.467	2025-07-09 17:22:29.468	3	3
\.


--
-- Data for Name: validator_ver; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.validator_ver (id, validator_id, schema, schema_hash, data_example, data_example_hash, create_date, create_user_id) FROM stdin;
1	1	{"items":{"properties":{"key":{"type":"string"},"value":{"type":"string"}},"required":["key","value"],"type":"object"},"type":"array"}	dc08164fede94254ef095f532764ccb7	[{"key":"SELF_CONTROL_LIMIT","value":"0.8"},{"key":"ROAD_ACCIDENTS_LIMIT","value":"100"},{"key":"SELF_CONTROL_STATE","value":"EMERGENCY_MODE"},{"key":"MAP_CENTER","value":"{\\"zoom\\":8,\\"lat\\":52.7,\\"lng\\":41.6}"}]	8bc200717dc1c06f9a83b62f0f8f85c6	2025-07-09 17:22:29.514	3
\.


--
-- Data for Name: widget; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.widget (id, enable, name, type, tags, config, permission_id, create_date, create_user_id, update_date, update_user_id) FROM stdin;
\.


--
-- Data for Name: worker_cron; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.worker_cron (id, worker_id, worker_param, next_update, interval_sec, create_date, update_date, create_user_id, update_user_id, description, enable, execution_time_min, execution_time_max, execution_time_average, subwork_min, subwork_max, subwork_average) FROM stdin;
7	update_stat_ds	{}	2025-07-10 08:20:18	541	2025-07-09 16:38:44.737	2025-07-09 16:38:44.737	3	3		t	0	0	0	2	2	2
8	update_stat_cron	{"leftLogs":100}	2025-07-10 08:20:31	547	2025-07-09 16:38:57.56	2025-07-09 16:38:57.56	3	3		t	0	0	0	2	2	2
4	adapter_dump	{"path":"backup/adapter"}	2025-07-11 00:00:00	86400	2025-07-09 16:37:42.553	2025-07-09 16:37:42.553	3	3		t	0	0	0	0	0	0
5	module_dump	{"path":"backup/module"}	2025-07-11 00:00:00	86400	2025-07-09 16:37:58.126	2025-07-09 16:37:58.126	3	3		t	0	0	0	0	0	0
6	widget_dump	{"path":"backup/widget"}	2025-07-11 00:00:00	86400	2025-07-09 16:38:13.462	2025-07-09 16:38:13.462	3	3		t	0	0	0	0	0	0
9	clear_upload	{"expiresH":168}	2025-07-11 00:00:00	86400	2025-07-09 16:39:21.959	2025-07-09 16:39:21.959	3	3		t	0	0	0	0	0	0
3	ds_dump	{"path":"backup/ds"}	2025-07-11 00:00:00	86400	2025-07-09 16:37:28.652	2025-07-09 16:37:28.652	3	3		t	0	0	0	0	0	0
2	oauth2_session_worker	{}	2025-07-10 08:32:00	3607	2025-07-09 16:36:52.796	2025-07-09 16:36:52.796	3	3		t	0	0	0	2	2	2
1	ds_credentials	{}	2025-07-10 08:47:09	3593	2025-07-09 16:36:29.182	2025-07-09 16:36:29.182	3	3		t	0	0	0	2	2	2
\.


--
-- Data for Name: worker_cron_time_log; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.worker_cron_time_log (id, worker_id, start_time, end_time, subwork_count) FROM stdin;
\.


--
-- Data for Name: geocode_settings; Type: TABLE DATA; Schema: tiger; Owner: postgres
--

COPY tiger.geocode_settings (name, setting, unit, category, short_desc) FROM stdin;
\.


--
-- Data for Name: pagc_gaz; Type: TABLE DATA; Schema: tiger; Owner: postgres
--

COPY tiger.pagc_gaz (id, seq, word, stdword, token, is_custom) FROM stdin;
\.


--
-- Data for Name: pagc_lex; Type: TABLE DATA; Schema: tiger; Owner: postgres
--

COPY tiger.pagc_lex (id, seq, word, stdword, token, is_custom) FROM stdin;
\.


--
-- Data for Name: pagc_rules; Type: TABLE DATA; Schema: tiger; Owner: postgres
--

COPY tiger.pagc_rules (id, rule, is_custom) FROM stdin;
\.


--
-- Data for Name: topology; Type: TABLE DATA; Schema: topology; Owner: postgres
--

COPY topology.topology (id, name, srid, "precision", hasz) FROM stdin;
\.


--
-- Data for Name: layer; Type: TABLE DATA; Schema: topology; Owner: postgres
--

COPY topology.layer (topology_id, layer_id, schema_name, table_name, feature_column, feature_type, level, child_id) FROM stdin;
\.


--
-- Name: callback_event_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.callback_event_id_seq', 1, false);


--
-- Name: citizens_appeals_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.citizens_appeals_id_seq', 1, false);


--
-- Name: comment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.comment_id_seq', 1, false);


--
-- Name: ct_override_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.ct_override_id_seq', 1, false);


--
-- Name: data_source_user_params_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.data_source_user_params_id_seq', 1, false);


--
-- Name: dc_event_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.dc_event_id_seq', 1, false);


--
-- Name: dc_flag_device_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.dc_flag_device_id_seq', 1, false);


--
-- Name: dc_task_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.dc_task_id_seq', 1, false);


--
-- Name: file_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.file_id_seq', 1, true);


--
-- Name: file_view_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.file_view_id_seq', 1, false);


--
-- Name: geo_object_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.geo_object_id_seq', 1, true);


--
-- Name: geo_object_ver_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.geo_object_ver_id_seq', 1, true);


--
-- Name: logs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.logs_id_seq', 158, true);


--
-- Name: migrations_v2_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.migrations_v2_id_seq', 107, true);


--
-- Name: notification_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.notification_id_seq', 1, false);


--
-- Name: object_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.object_id_seq', 1, false);


--
-- Name: permitted_route_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.permitted_route_id_seq', 1, false);


--
-- Name: permitted_route_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.permitted_route_link_id_seq', 1, false);


--
-- Name: resource_exists_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.resource_exists_id_seq', 9769, true);


--
-- Name: sadis_contract_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.sadis_contract_id_seq', 1, false);


--
-- Name: static_access_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.static_access_id_seq', 3, true);


--
-- Name: user_external_id_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_external_id_id_seq', 1, false);


--
-- Name: user_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_id_seq', 3, true);


--
-- Name: user_online_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_online_id_seq', 102, true);


--
-- Name: user_session_oauth2_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_session_oauth2_id_seq', 15, true);


--
-- Name: user_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.user_settings_id_seq', 1, false);


--
-- Name: validator_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.validator_id_seq', 1, true);


--
-- Name: validator_ver_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.validator_ver_id_seq', 1, true);


--
-- Name: worker_cron_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.worker_cron_id_seq', 9, true);


--
-- Name: worker_cron_time_log_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.worker_cron_time_log_id_seq', 242, true);


--
-- Name: topology_id_seq; Type: SEQUENCE SET; Schema: topology; Owner: postgres
--

SELECT pg_catalog.setval('topology.topology_id_seq', 1, false);


--
-- Name: migrations_v2 PK_29229ae6656a912002424806a0d; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.migrations_v2
    ADD CONSTRAINT "PK_29229ae6656a912002424806a0d" PRIMARY KEY (id);


--
-- Name: user PK_cace4a159ff9f2512dd42373760; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT "PK_cace4a159ff9f2512dd42373760" PRIMARY KEY (id);


--
-- Name: user UQ_a62473490b3e4578fd683235c5e; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT "UQ_a62473490b3e4578fd683235c5e" UNIQUE (login);


--
-- Name: user UQ_e12875dfb3b1d92d7d7c5377e22; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public."user"
    ADD CONSTRAINT "UQ_e12875dfb3b1d92d7d7c5377e22" UNIQUE (email);


--
-- Name: adapter adapter_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.adapter
    ADD CONSTRAINT adapter_pk PRIMARY KEY (id);


--
-- Name: callback_event callback_event_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.callback_event
    ADD CONSTRAINT callback_event_pk PRIMARY KEY (id);


--
-- Name: citizens_appeals citizens_appeals_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.citizens_appeals
    ADD CONSTRAINT citizens_appeals_pk PRIMARY KEY (id);


--
-- Name: comment comment_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comment
    ADD CONSTRAINT comment_pkey PRIMARY KEY (id);


--
-- Name: ct_override ct_override_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override
    ADD CONSTRAINT ct_override_pk PRIMARY KEY (id);


--
-- Name: ct_override ct_override_pk_2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override
    ADD CONSTRAINT ct_override_pk_2 UNIQUE (data_type, data_id, subsystem_id, set);


--
-- Name: dashboard dashboard_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_pk PRIMARY KEY (id);


--
-- Name: data_source data_source_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source
    ADD CONSTRAINT data_source_pk PRIMARY KEY (id);


--
-- Name: data_source_query data_source_query_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_pk PRIMARY KEY (id);


--
-- Name: data_source_user_params data_source_user_params_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params
    ADD CONSTRAINT data_source_user_params_pk UNIQUE (data_source_id, user_id);


--
-- Name: dc_config dc_config_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config
    ADD CONSTRAINT dc_config_pkey PRIMARY KEY (id);


--
-- Name: dc_config_subsystem dc_config_subsystem_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config_subsystem
    ADD CONSTRAINT dc_config_subsystem_pk PRIMARY KEY (dc_config_id, subsystem_id);


--
-- Name: dc_event dc_event_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_event
    ADD CONSTRAINT dc_event_pk PRIMARY KEY (id);


--
-- Name: dc_flag_device dc_flag_device_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_pk PRIMARY KEY (id);


--
-- Name: dc_flag dc_flag_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag
    ADD CONSTRAINT dc_flag_pk PRIMARY KEY (id);


--
-- Name: dc_task dc_task_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_task
    ADD CONSTRAINT dc_task_pk PRIMARY KEY (id);


--
-- Name: file file_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_pk PRIMARY KEY (id);


--
-- Name: file_view file_view_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file_view
    ADD CONSTRAINT file_view_pk PRIMARY KEY (id);


--
-- Name: form form_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_pk PRIMARY KEY (id);


--
-- Name: geo_object geo_object_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object
    ADD CONSTRAINT geo_object_pk PRIMARY KEY (id);


--
-- Name: geo_object_ver geo_object_ver_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object_ver
    ADD CONSTRAINT geo_object_ver_pk PRIMARY KEY (id);


--
-- Name: link link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.link
    ADD CONSTRAINT link_pk PRIMARY KEY (id);


--
-- Name: logs logs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logs
    ADD CONSTRAINT logs_pkey PRIMARY KEY (id);


--
-- Name: module module_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module
    ADD CONSTRAINT module_pk PRIMARY KEY (id);


--
-- Name: notification notification_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.notification
    ADD CONSTRAINT notification_pk PRIMARY KEY (id);


--
-- Name: object object_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.object
    ADD CONSTRAINT object_pk PRIMARY KEY (id);


--
-- Name: object object_pk_2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.object
    ADD CONSTRAINT object_pk_2 UNIQUE (entity_id, type);


--
-- Name: permission permission_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission
    ADD CONSTRAINT permission_pk PRIMARY KEY (id);


--
-- Name: permitted_route_link permitted_route_link_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permitted_route_link
    ADD CONSTRAINT permitted_route_link_pk PRIMARY KEY (id);


--
-- Name: permitted_route permitted_route_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permitted_route
    ADD CONSTRAINT permitted_route_pk PRIMARY KEY (id);


--
-- Name: resource_exists resource_exists_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resource_exists
    ADD CONSTRAINT resource_exists_pk PRIMARY KEY (id);


--
-- Name: resource_lock resource_lock_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resource_lock
    ADD CONSTRAINT resource_lock_pk PRIMARY KEY (resource_id);


--
-- Name: resource_lock resource_lock_pk_2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.resource_lock
    ADD CONSTRAINT resource_lock_pk_2 UNIQUE (expire);


--
-- Name: role_permission role_permission_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_pk PRIMARY KEY (role_id, permission_id);


--
-- Name: role role_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role
    ADD CONSTRAINT role_pk PRIMARY KEY (id);


--
-- Name: sadis_contract sadis_contract_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract
    ADD CONSTRAINT sadis_contract_pk PRIMARY KEY (id);


--
-- Name: sadis_contract sadis_contract_pk_2; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract
    ADD CONSTRAINT sadis_contract_pk_2 UNIQUE (geo_object_id);


--
-- Name: sadis_interval sadis_interval_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_interval
    ADD CONSTRAINT sadis_interval_pk PRIMARY KEY (id);


--
-- Name: settings settings_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.settings
    ADD CONSTRAINT settings_pk PRIMARY KEY (key);


--
-- Name: static_access static_access_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.static_access
    ADD CONSTRAINT static_access_pk PRIMARY KEY (id);


--
-- Name: subsystem subsystem_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.subsystem
    ADD CONSTRAINT subsystem_pk PRIMARY KEY (id);


--
-- Name: sync_data sync_data_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sync_data
    ADD CONSTRAINT sync_data_pk PRIMARY KEY (node_id);


--
-- Name: temporary_data temporary_data_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.temporary_data
    ADD CONSTRAINT temporary_data_pk PRIMARY KEY (key);


--
-- Name: user_external_id user_external_id_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id
    ADD CONSTRAINT user_external_id_pk PRIMARY KEY (id);


--
-- Name: user_online user_online_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_online
    ADD CONSTRAINT user_online_pk PRIMARY KEY (id);


--
-- Name: user_permission user_permission_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_permission
    ADD CONSTRAINT user_permission_pk PRIMARY KEY (user_id, permission_id);


--
-- Name: user_role user_role_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_pk PRIMARY KEY (user_id, role_id);


--
-- Name: session user_session_oauth2_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT user_session_oauth2_pk PRIMARY KEY (id);


--
-- Name: user_session user_session_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_session
    ADD CONSTRAINT user_session_pk PRIMARY KEY (id);


--
-- Name: user_settings user_settings_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_settings
    ADD CONSTRAINT user_settings_pk PRIMARY KEY (id);


--
-- Name: validator validator_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator
    ADD CONSTRAINT validator_pk PRIMARY KEY (id);


--
-- Name: validator_ver validator_ver_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator_ver
    ADD CONSTRAINT validator_ver_pk PRIMARY KEY (id);


--
-- Name: widget widget_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.widget
    ADD CONSTRAINT widget_pk PRIMARY KEY (id);


--
-- Name: worker_cron worker_cron_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron
    ADD CONSTRAINT worker_cron_pk PRIMARY KEY (id);


--
-- Name: worker_cron_time_log worker_cron_time_log_pk; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron_time_log
    ADD CONSTRAINT worker_cron_time_log_pk PRIMARY KEY (id);


--
-- Name: adapter_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX adapter_enable_index ON public.adapter USING btree (enable);


--
-- Name: adapter_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX adapter_type_index ON public.adapter USING btree (type);


--
-- Name: callback_event_object_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX callback_event_object_id_index ON public.callback_event USING btree (object_id);


--
-- Name: callback_event_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX callback_event_type_index ON public.callback_event USING btree (type);


--
-- Name: callback_event_uid_type_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX callback_event_uid_type_uindex ON public.callback_event USING btree (uid, type);


--
-- Name: citizens_appeals_create_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX citizens_appeals_create_date_index ON public.citizens_appeals USING btree (create_date);


--
-- Name: citizens_appeals_ip_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX citizens_appeals_ip_index ON public.citizens_appeals USING btree (ip);


--
-- Name: citizens_appeals_user_agent_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX citizens_appeals_user_agent_index ON public.citizens_appeals USING btree (user_agent);


--
-- Name: comment_object_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX comment_object_id_index ON public.comment USING btree (object_id);


--
-- Name: comment_object_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX comment_object_type_index ON public.comment USING btree (object_type);


--
-- Name: ct_override_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ct_override_enable_index ON public.ct_override USING btree (enable);


--
-- Name: dashboard_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dashboard_enable_index ON public.dashboard USING btree (enable);


--
-- Name: dashboard_is_private_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dashboard_is_private_index ON public.dashboard USING btree (is_private);


--
-- Name: data_source_auth_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_auth_type_index ON public.data_source USING btree (auth_type);


--
-- Name: data_source_credentials_next_update_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_credentials_next_update_index ON public.data_source USING btree (credentials_next_update);


--
-- Name: data_source_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_enable_index ON public.data_source USING btree (enable);


--
-- Name: data_source_query_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_query_enable_index ON public.data_source_query USING btree (enable);


--
-- Name: data_source_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_type_index ON public.data_source USING btree (protocol);


--
-- Name: data_source_user_params_credentials_next_update_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_user_params_credentials_next_update_index ON public.data_source_user_params USING btree (credentials_next_update);


--
-- Name: data_source_user_params_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_user_params_enable_index ON public.data_source_user_params USING btree (enable);


--
-- Name: data_source_user_params_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX data_source_user_params_index ON public.data_source USING btree (user_params);


--
-- Name: dc_config_actual_data_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_config_actual_data_index ON public.dc_config USING btree (actual_data);


--
-- Name: dc_config_data_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_config_data_type_index ON public.dc_config USING btree (data_type);


--
-- Name: dc_config_delete_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_config_delete_index ON public.dc_config USING btree (delete);


--
-- Name: dc_config_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_config_enable_index ON public.dc_config USING btree (enable);


--
-- Name: dc_event_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_event_date_index ON public.dc_event USING btree (date);


--
-- Name: dc_event_dc_config_id_data_id_date_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX dc_event_dc_config_id_data_id_date_uindex ON public.dc_event USING btree (dc_config_id, data_id, date);


--
-- Name: dc_event_dc_config_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_event_dc_config_id_index ON public.dc_event USING btree (dc_config_id);


--
-- Name: dc_event_status_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_event_status_index ON public.dc_event USING btree (status);


--
-- Name: dc_flag_device_data_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_data_type_index ON public.dc_flag_device USING btree (data_type);


--
-- Name: dc_flag_device_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_date_index ON public.dc_flag_device USING btree (date);


--
-- Name: dc_flag_device_device_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_device_id_index ON public.dc_flag_device USING btree (device_id);


--
-- Name: dc_flag_device_expiries_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_expiries_index ON public.dc_flag_device USING btree (expiries);


--
-- Name: dc_flag_device_lvl_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_lvl_index ON public.dc_flag_device USING btree (lvl);


--
-- Name: dc_flag_device_status_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_device_status_index ON public.dc_flag_device USING btree (status);


--
-- Name: dc_flag_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_flag_enable_index ON public.dc_flag USING btree (enable);


--
-- Name: dc_task_expires_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_expires_index ON public.dc_task USING btree (next_repeat_date);


--
-- Name: dc_task_lock_expires_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_lock_expires_index ON public.dc_task USING btree (lock_expires);


--
-- Name: dc_task_lock_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_lock_id_index ON public.dc_task USING btree (lock_id);


--
-- Name: dc_task_next_repeat_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_next_repeat_date_index ON public.dc_task USING btree (next_repeat_date);


--
-- Name: dc_task_repetition_interval_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_repetition_interval_index ON public.dc_task USING btree (repetition_interval);


--
-- Name: dc_task_repetitions_left_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_repetitions_left_index ON public.dc_task USING btree (repetitions_left);


--
-- Name: dc_task_status_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_status_index ON public.dc_task USING btree (status);


--
-- Name: dc_task_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX dc_task_type_index ON public.dc_task USING btree (type);


--
-- Name: file_create_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_create_date_index ON public.file USING btree (create_date);


--
-- Name: file_create_user_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_create_user_id_index ON public.file USING btree (create_user_id);


--
-- Name: file_ext_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_ext_index ON public.file USING btree (ext);


--
-- Name: file_hash_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_hash_index ON public.file USING btree (hash);


--
-- Name: file_is_dir_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_is_dir_index ON public.file USING btree (is_dir);


--
-- Name: file_name_ext_parent_id_is_dir_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX file_name_ext_parent_id_is_dir_uindex ON public.file USING btree (name, ext, parent_id, is_dir);


--
-- Name: file_size_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_size_index ON public.file USING btree (size);


--
-- Name: file_update_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_update_date_index ON public.file USING btree (update_date);


--
-- Name: file_update_user_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX file_update_user_id_index ON public.file USING btree (update_user_id);


--
-- Name: file_view_file_id_user_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX file_view_file_id_user_id_uindex ON public.file_view USING btree (file_id, user_id);


--
-- Name: geo_collection_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX geo_collection_id_uindex ON public.geo_collection USING btree (id);


--
-- Name: geo_object_data_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_data_type_index ON public.geo_object USING gin (data_type);


--
-- Name: geo_object_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_enable_index ON public.data_source USING btree (enable);


--
-- Name: geo_object_geometry_bounds_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_geometry_bounds_index ON public.geo_object USING gist (geometry_bounds);


--
-- Name: geo_object_geometry_hash_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_geometry_hash_index ON public.geo_object USING btree (geometry_hash);


--
-- Name: geo_object_geometry_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_geometry_index ON public.geo_object USING gist (geometry);


--
-- Name: geo_object_geometry_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_geometry_type_index ON public.geo_object USING btree (geometry_type);


--
-- Name: geo_object_key_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX geo_object_key_uindex ON public.geo_object USING btree (key);


--
-- Name: geo_object_ver_geometry_hash_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_ver_geometry_hash_index ON public.geo_object_ver USING btree (geometry_hash);


--
-- Name: geo_object_ver_geometry_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX geo_object_ver_geometry_type_index ON public.geo_object_ver USING btree (geometry_type);


--
-- Name: logs_action_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX logs_action_index ON public.logs USING btree (action);


--
-- Name: logs_create_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX logs_create_date_index ON public.logs USING btree (create_date);


--
-- Name: logs_data_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX logs_data_id_index ON public.logs USING btree (data_id);


--
-- Name: module_is_private_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX module_is_private_index ON public.module USING btree (is_private);


--
-- Name: module_sort_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX module_sort_index ON public.module USING btree (sort);


--
-- Name: module_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX module_type_index ON public.module USING btree (type);


--
-- Name: notification_created_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_created_index ON public.notification USING btree (created);


--
-- Name: notification_expiry_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_expiry_index ON public.notification USING btree (expiry);


--
-- Name: notification_external_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX notification_external_id_uindex ON public.notification USING btree (external_id);


--
-- Name: notification_lvl_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_lvl_index ON public.notification USING btree (lvl);


--
-- Name: notification_tags_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_tags_index ON public.notification USING btree (tags);


--
-- Name: notification_title_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_title_index ON public.notification USING btree (title);


--
-- Name: notification_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX notification_type_index ON public.notification USING btree (type);


--
-- Name: notification_user_user_id_notification_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX notification_user_user_id_notification_id_uindex ON public.notification_user USING btree (user_id, notification_id);


--
-- Name: object_tags_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX object_tags_index ON public.object USING gin (tags);


--
-- Name: object_type_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX object_type_index ON public.object USING btree (type);


--
-- Name: permitted_route_data_hash_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX permitted_route_data_hash_uindex ON public.permitted_route USING btree (data_hash);


--
-- Name: permitted_route_link_car_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX permitted_route_link_car_uindex ON public.permitted_route_link USING btree (car);


--
-- Name: permitted_route_link_complex_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX permitted_route_link_complex_uindex ON public.permitted_route_link USING btree (complex);


--
-- Name: resource_exists_type_exist_key_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX resource_exists_type_exist_key_uindex ON public.resource_exists USING btree (type, exist, key);


--
-- Name: role_permission_permission_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX role_permission_permission_id_index ON public.role_permission USING btree (permission_id);


--
-- Name: sadis_contract_end_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX sadis_contract_end_date_index ON public.sadis_contract USING btree (end_date);


--
-- Name: sadis_contract_sadis_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX sadis_contract_sadis_id_index ON public.sadis_contract USING btree (sadis_id);


--
-- Name: sadis_contract_start_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX sadis_contract_start_date_index ON public.sadis_contract USING btree (start_date);


--
-- Name: static_access_rule_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX static_access_rule_uindex ON public.static_access USING btree (rule);


--
-- Name: static_access_sort_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX static_access_sort_index ON public.static_access USING btree (sort);


--
-- Name: subsystem_name_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX subsystem_name_uindex ON public.subsystem USING btree (name);


--
-- Name: temporary_data_expires_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX temporary_data_expires_index ON public.temporary_data USING btree (expires);


--
-- Name: user_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_enable_index ON public."user" USING btree (enable);


--
-- Name: user_external_id_external_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_external_id_external_id_index ON public.user_external_id USING btree (external_id);


--
-- Name: user_external_id_user_id_subsystem_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_external_id_user_id_subsystem_id_uindex ON public.user_external_id USING btree (user_id, subsystem_id);


--
-- Name: user_online_node_id_connection_id_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_online_node_id_connection_id_uindex ON public.user_online USING btree (node_id, connection_id);


--
-- Name: user_permission_permission_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_permission_permission_id_index ON public.user_permission USING btree (permission_id);


--
-- Name: user_properties_user_id_key_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_properties_user_id_key_uindex ON public.user_settings USING btree (user_id, key);


--
-- Name: user_role_role_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_role_role_id_index ON public.user_role USING btree (role_id);


--
-- Name: user_secret_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_secret_uindex ON public."user" USING btree (secret);


--
-- Name: user_session_end_time_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_session_end_time_index ON public.user_session USING btree (end_time);


--
-- Name: user_session_oauth2_access_token_expire_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_session_oauth2_access_token_expire_index ON public.session USING btree (access_token_expire);


--
-- Name: user_session_oauth2_access_token_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_session_oauth2_access_token_uindex ON public.session USING btree (access_token);


--
-- Name: user_session_oauth2_refresh_token_expire_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_session_oauth2_refresh_token_expire_index ON public.session USING btree (refresh_token_expire);


--
-- Name: user_session_oauth2_refresh_token_uindex; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX user_session_oauth2_refresh_token_uindex ON public.session USING btree (refresh_token);


--
-- Name: user_session_user_id_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX user_session_user_id_index ON public.user_session USING btree (user_id);


--
-- Name: validator_ver_data_example_hash_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX validator_ver_data_example_hash_index ON public.validator_ver USING btree (data_example_hash);


--
-- Name: validator_ver_schema_hash_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX validator_ver_schema_hash_index ON public.validator_ver USING btree (schema_hash);


--
-- Name: widget_create_date_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX widget_create_date_index ON public.widget USING btree (create_date);


--
-- Name: widget_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX widget_enable_index ON public.widget USING btree (enable);


--
-- Name: worker_cron_enable_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX worker_cron_enable_index ON public.worker_cron USING btree (enable);


--
-- Name: worker_cron_interval_sec_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX worker_cron_interval_sec_index ON public.worker_cron USING btree (interval_sec);


--
-- Name: worker_cron_next_update_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX worker_cron_next_update_index ON public.worker_cron USING btree (next_update);


--
-- Name: worker_cron_time_log_start_time_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX worker_cron_time_log_start_time_index ON public.worker_cron_time_log USING btree (start_time);


--
-- Name: worker_cron_worker_index; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX worker_cron_worker_index ON public.worker_cron USING btree (worker_id);


--
-- Name: logs before_delete_logs; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER before_delete_logs BEFORE DELETE ON public.logs FOR EACH ROW EXECUTE FUNCTION public.f_before_delete_logs();


--
-- Name: logs before_update_logs; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER before_update_logs BEFORE UPDATE ON public.logs FOR EACH ROW EXECUTE FUNCTION public.f_before_update_logs();


--
-- Name: adapter adapter_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.adapter
    ADD CONSTRAINT adapter_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: adapter adapter_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.adapter
    ADD CONSTRAINT adapter_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: adapter adapter_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.adapter
    ADD CONSTRAINT adapter_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: comment comment_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comment
    ADD CONSTRAINT comment_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: comment comment_user_id_fk2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comment
    ADD CONSTRAINT comment_user_id_fk2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: ct_override ct_override_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override
    ADD CONSTRAINT ct_override_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id) ON UPDATE CASCADE;


--
-- Name: ct_override ct_override_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override
    ADD CONSTRAINT ct_override_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: ct_override ct_override_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ct_override
    ADD CONSTRAINT ct_override_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dashboard dashboard_edit_perm_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_edit_perm_id_fk FOREIGN KEY (edit_perm_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: dashboard dashboard_read_perm_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_read_perm_id_fk FOREIGN KEY (read_perm_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: dashboard dashboard_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dashboard dashboard_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dashboard
    ADD CONSTRAINT dashboard_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: data_source data_source_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source
    ADD CONSTRAINT data_source_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: data_source_query data_source_query_data_source_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_data_source_id_fk FOREIGN KEY (data_source_id) REFERENCES public.data_source(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: data_source_query data_source_query_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: data_source_query data_source_query_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: data_source_query data_source_query_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id);


--
-- Name: data_source_query data_source_query_validator_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_query
    ADD CONSTRAINT data_source_query_validator_id_fk FOREIGN KEY (validator_id) REFERENCES public.validator(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: data_source data_source_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source
    ADD CONSTRAINT data_source_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: data_source data_source_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source
    ADD CONSTRAINT data_source_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: data_source data_source_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source
    ADD CONSTRAINT data_source_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id);


--
-- Name: data_source_user_params data_source_user_params_data_source_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params
    ADD CONSTRAINT data_source_user_params_data_source_id_fk FOREIGN KEY (data_source_id) REFERENCES public.data_source(id);


--
-- Name: data_source_user_params data_source_user_params_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params
    ADD CONSTRAINT data_source_user_params_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: data_source_user_params data_source_user_params_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params
    ADD CONSTRAINT data_source_user_params_user_id_fk_2 FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: data_source_user_params data_source_user_params_user_id_fk_3; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.data_source_user_params
    ADD CONSTRAINT data_source_user_params_user_id_fk_3 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dc_config_subsystem dc_config_subsystem_dc_config_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config_subsystem
    ADD CONSTRAINT dc_config_subsystem_dc_config_id_fk FOREIGN KEY (dc_config_id) REFERENCES public.dc_config(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: dc_config_subsystem dc_config_subsystem_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config_subsystem
    ADD CONSTRAINT dc_config_subsystem_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: dc_config dc_config_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config
    ADD CONSTRAINT dc_config_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: dc_config dc_config_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_config
    ADD CONSTRAINT dc_config_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: dc_event dc_event_dc_config_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_event
    ADD CONSTRAINT dc_event_dc_config_id_fk FOREIGN KEY (dc_config_id) REFERENCES public.dc_config(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: dc_flag_device dc_flag_device_dc_config_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_dc_config_id_fk FOREIGN KEY (dc_config_id) REFERENCES public.dc_config(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: dc_flag_device dc_flag_device_dc_flag_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_dc_flag_id_fk FOREIGN KEY (dc_flag_id) REFERENCES public.dc_flag(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: dc_flag_device dc_flag_device_dc_task_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_dc_task_id_fk FOREIGN KEY (dc_task_id) REFERENCES public.dc_task(id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- Name: dc_flag_device dc_flag_device_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id) ON UPDATE CASCADE;


--
-- Name: dc_flag_device dc_flag_device_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag_device
    ADD CONSTRAINT dc_flag_device_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dc_flag dc_flag_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag
    ADD CONSTRAINT dc_flag_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dc_flag dc_flag_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_flag
    ADD CONSTRAINT dc_flag_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: dc_task dc_task_dc_event_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_task
    ADD CONSTRAINT dc_task_dc_event_id_fk FOREIGN KEY (dc_event_id) REFERENCES public.dc_event(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: dc_task dc_task_dc_task_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.dc_task
    ADD CONSTRAINT dc_task_dc_task_id_fk FOREIGN KEY (parent_id) REFERENCES public.dc_task(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: file file_file_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_file_id_fk FOREIGN KEY (parent_id) REFERENCES public.file(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: file file_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_permission_id_fk FOREIGN KEY (perm_c) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: file file_permission_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_permission_id_fk_2 FOREIGN KEY (perm_r) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: file file_permission_id_fk_3; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_permission_id_fk_3 FOREIGN KEY (perm_u) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: file file_permission_id_fk_4; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_permission_id_fk_4 FOREIGN KEY (perm_d) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: file file_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: file file_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file
    ADD CONSTRAINT file_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: file_view file_view_file_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file_view
    ADD CONSTRAINT file_view_file_id_fk FOREIGN KEY (file_id) REFERENCES public.file(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: file_view file_view_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.file_view
    ADD CONSTRAINT file_view_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: logs fk_subsystem_id; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logs
    ADD CONSTRAINT fk_subsystem_id FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id);


--
-- Name: form form_permission_id_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_permission_id_fk_1 FOREIGN KEY (perm_c) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: form form_permission_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_permission_id_fk_2 FOREIGN KEY (perm_r) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: form form_permission_id_fk_3; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_permission_id_fk_3 FOREIGN KEY (perm_u) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: form form_permission_id_fk_4; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_permission_id_fk_4 FOREIGN KEY (perm_d) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: form form_user_id_fk_1; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_user_id_fk_1 FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: form form_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.form
    ADD CONSTRAINT form_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: geo_collection geo_collection_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_collection
    ADD CONSTRAINT geo_collection_permission_id_fk FOREIGN KEY (perm_r) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: geo_collection geo_collection_permission_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_collection
    ADD CONSTRAINT geo_collection_permission_id_fk_2 FOREIGN KEY (perm_u) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: geo_object geo_object_geo_collection_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object
    ADD CONSTRAINT geo_object_geo_collection_id_fk FOREIGN KEY (collection_id) REFERENCES public.geo_collection(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: geo_object geo_object_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object
    ADD CONSTRAINT geo_object_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: geo_object geo_object_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object
    ADD CONSTRAINT geo_object_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: geo_object geo_object_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object
    ADD CONSTRAINT geo_object_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id);


--
-- Name: geo_object_ver geo_object_ver_geo_object_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object_ver
    ADD CONSTRAINT geo_object_ver_geo_object_id_fk FOREIGN KEY (geo_object_id) REFERENCES public.geo_object(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: geo_object_ver geo_object_ver_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.geo_object_ver
    ADD CONSTRAINT geo_object_ver_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: link link_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.link
    ADD CONSTRAINT link_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id);


--
-- Name: comment logs_to_user_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.comment
    ADD CONSTRAINT logs_to_user_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: logs logs_to_user_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logs
    ADD CONSTRAINT logs_to_user_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: logs logs_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.logs
    ADD CONSTRAINT logs_user_id_fk FOREIGN KEY (real_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: module module_permission_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module
    ADD CONSTRAINT module_permission_id_fk_2 FOREIGN KEY (read_perm_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: module module_permission_id_fk_3; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module
    ADD CONSTRAINT module_permission_id_fk_3 FOREIGN KEY (edit_perm_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: module module_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module
    ADD CONSTRAINT module_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: module module_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.module
    ADD CONSTRAINT module_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: notification_user notification_user_notification_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.notification_user
    ADD CONSTRAINT notification_user_notification_id_fk FOREIGN KEY (notification_id) REFERENCES public.notification(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: notification_user notification_user_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.notification_user
    ADD CONSTRAINT notification_user_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: object object_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.object
    ADD CONSTRAINT object_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: object object_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.object
    ADD CONSTRAINT object_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: permission permission_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permission
    ADD CONSTRAINT permission_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id);


--
-- Name: permitted_route permitted_route_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.permitted_route
    ADD CONSTRAINT permitted_route_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: role_permission role_permission_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: role_permission role_permission_role_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.role_permission
    ADD CONSTRAINT role_permission_role_id_fk FOREIGN KEY (role_id) REFERENCES public.role(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: sadis_contract sadis_contract_geo_object_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract
    ADD CONSTRAINT sadis_contract_geo_object_id_fk FOREIGN KEY (geo_object_id) REFERENCES public.geo_object(id) ON UPDATE CASCADE;


--
-- Name: sadis_contract sadis_contract_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract
    ADD CONSTRAINT sadis_contract_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: sadis_contract sadis_contract_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sadis_contract
    ADD CONSTRAINT sadis_contract_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: session session_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT session_user_id_fk FOREIGN KEY (provider_id) REFERENCES public."user"(id);


--
-- Name: session session_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT session_user_id_fk_2 FOREIGN KEY (real_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: static_access static_access_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.static_access
    ADD CONSTRAINT static_access_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: static_access static_access_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.static_access
    ADD CONSTRAINT static_access_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: static_access static_access_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.static_access
    ADD CONSTRAINT static_access_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: user_external_id user_external_id_subsystem_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id
    ADD CONSTRAINT user_external_id_subsystem_id_fk FOREIGN KEY (subsystem_id) REFERENCES public.subsystem(id) ON UPDATE CASCADE;


--
-- Name: user_external_id user_external_id_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id
    ADD CONSTRAINT user_external_id_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_external_id user_external_id_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id
    ADD CONSTRAINT user_external_id_user_id_fk_2 FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: user_external_id user_external_id_user_id_fk_3; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_external_id
    ADD CONSTRAINT user_external_id_user_id_fk_3 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: user_online user_online_session_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_online
    ADD CONSTRAINT user_online_session_id_fk FOREIGN KEY (session_id) REFERENCES public.session(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_permission user_permission_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_permission
    ADD CONSTRAINT user_permission_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_permission user_permission_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_permission
    ADD CONSTRAINT user_permission_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_role user_role_role_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_role_id_fk FOREIGN KEY (role_id) REFERENCES public.role(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_role user_role_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_role
    ADD CONSTRAINT user_role_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: session user_session_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT user_session_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: user_session user_session_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.user_session
    ADD CONSTRAINT user_session_user_id_fk FOREIGN KEY (user_id) REFERENCES public."user"(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: validator validator_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator
    ADD CONSTRAINT validator_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: validator validator_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator
    ADD CONSTRAINT validator_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id);


--
-- Name: validator_ver validator_ver_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator_ver
    ADD CONSTRAINT validator_ver_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: validator_ver validator_ver_validator_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.validator_ver
    ADD CONSTRAINT validator_ver_validator_id_fk FOREIGN KEY (validator_id) REFERENCES public.validator(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: widget widget_permission_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.widget
    ADD CONSTRAINT widget_permission_id_fk FOREIGN KEY (permission_id) REFERENCES public.permission(id) ON UPDATE CASCADE;


--
-- Name: widget widget_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.widget
    ADD CONSTRAINT widget_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: widget widget_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.widget
    ADD CONSTRAINT widget_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id) ON UPDATE CASCADE;


--
-- Name: worker_cron_time_log worker_cron_time_log_worker_cron_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron_time_log
    ADD CONSTRAINT worker_cron_time_log_worker_cron_id_fk FOREIGN KEY (worker_id) REFERENCES public.worker_cron(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: worker_cron worker_cron_user_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron
    ADD CONSTRAINT worker_cron_user_id_fk FOREIGN KEY (create_user_id) REFERENCES public."user"(id);


--
-- Name: worker_cron worker_cron_user_id_fk_2; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.worker_cron
    ADD CONSTRAINT worker_cron_user_id_fk_2 FOREIGN KEY (update_user_id) REFERENCES public."user"(id);


--
-- PostgreSQL database dump complete
--

\unrestrict u7Fu9aASc9b6XuPhhg7MwGCJPiPMYsvd3Bo3BWvMT5TsBFn7H6SDFVkhmL6l1Ua

